<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Discount Structs
 * @subpackage Structs
 */
class Discount extends AbstractStructBase
{
    /**
     * The DiscountDescription
     * Meta informations extracted from the WSDL
     * - documentation: Discount description
     * - minOccurs: 0
     * @var string
     */
    public $DiscountDescription;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Discount amount
     * @var float
     */
    public $amount;
    /**
     * The currencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Currency code
     * @var string
     */
    public $currencyCode;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Discount type
     * @var string
     */
    public $type;
    /**
     * The category
     * @var string
     */
    public $category;
    /**
     * The promoType
     * @var string
     */
    public $promoType;
    /**
     * The promoCode
     * @var string
     */
    public $promoCode;
    /**
     * Constructor method for Discount
     * @uses Discount::setDiscountDescription()
     * @uses Discount::setAmount()
     * @uses Discount::setCurrencyCode()
     * @uses Discount::setType()
     * @uses Discount::setCategory()
     * @uses Discount::setPromoType()
     * @uses Discount::setPromoCode()
     * @param string $discountDescription
     * @param float $amount
     * @param string $currencyCode
     * @param string $type
     * @param string $category
     * @param string $promoType
     * @param string $promoCode
     */
    public function __construct($discountDescription = null, $amount = null, $currencyCode = null, $type = null, $category = null, $promoType = null, $promoCode = null)
    {
        $this
            ->setDiscountDescription($discountDescription)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setType($type)
            ->setCategory($category)
            ->setPromoType($promoType)
            ->setPromoCode($promoCode);
    }
    /**
     * Get DiscountDescription value
     * @return string|null
     */
    public function getDiscountDescription()
    {
        return $this->DiscountDescription;
    }
    /**
     * Set DiscountDescription value
     * @param string $discountDescription
     * @return \Sabre\TravelItineraryRead\Structs\Discount
     */
    public function setDiscountDescription($discountDescription = null)
    {
        $this->DiscountDescription = $discountDescription;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \Sabre\TravelItineraryRead\Structs\Discount
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\Discount
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Discount
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \Sabre\TravelItineraryRead\Structs\Discount
     */
    public function setCategory($category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get promoType value
     * @return string|null
     */
    public function getPromoType()
    {
        return $this->promoType;
    }
    /**
     * Set promoType value
     * @param string $promoType
     * @return \Sabre\TravelItineraryRead\Structs\Discount
     */
    public function setPromoType($promoType = null)
    {
        $this->promoType = $promoType;
        return $this;
    }
    /**
     * Get promoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param string $promoCode
     * @return \Sabre\TravelItineraryRead\Structs\Discount
     */
    public function setPromoCode($promoCode = null)
    {
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Discount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
