<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cruise Structs
 * @subpackage Structs
 */
class Cruise extends AbstractStructBase
{
    /**
     * The Berth
     * Meta informations extracted from the WSDL
     * - documentation: "Berth" is used to return the berth associated with the particular cruise segment if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Berth;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - documentation: "Cabin" is used to return the cabin associated with the particular cruise segment if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Cabin;
    /**
     * The CarRate
     * Meta informations extracted from the WSDL
     * - documentation: "CarRate" is used to return car rate-related information associated with the particular cruise segment if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CarRate;
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: "ConfirmationNumber" is used to return the confirmation number associated with the particular cruise segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ConfirmationNumber;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The Passenger
     * Meta informations extracted from the WSDL
     * - documentation: "Passenger" is used to return passenger-related information associated with the particular cruise segment if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Passenger;
    /**
     * The Seat
     * Meta informations extracted from the WSDL
     * - documentation: "Seat" is used to return the seat number associated with the particular cruise segment if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Seat;
    /**
     * The ServiceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ServiceInformation
     */
    public $ServiceInformation;
    /**
     * The ShipName
     * Meta informations extracted from the WSDL
     * - documentation: "ShipName" is used to return the ship name associated with the particular cruise segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ShipName;
    /**
     * The SpaceReserved
     * Meta informations extracted from the WSDL
     * - documentation: "SpaceReserved" is used to return space reserved-related information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SpaceReserved;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous free text associated with the particular cruise segment if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - documentation: "TotalFare" is used to return the total fare associated with the particular cruise segment if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TotalFare;
    /**
     * The TrailerPrice
     * Meta informations extracted from the WSDL
     * - documentation: "TrailerPrice" is used to return the trailer price associated with the particular cruise segment if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TrailerPrice;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public $Vendor;
    /**
     * The DayOfWeekInd
     * Meta informations extracted from the WSDL
     * - documentation: "DayOfWeekInd" is used to return the day of the week indicator.
     * - use: optional
     * @var string
     */
    public $DayOfWeekInd;
    /**
     * The LinkCode
     * Meta informations extracted from the WSDL
     * - documentation: "LinkCode" is used to return the link code
     * - use: optional
     * @var string
     */
    public $LinkCode;
    /**
     * The MergedSegmentInd
     * Meta informations extracted from the WSDL
     * - documentation: "MergedSegmentInd" is used to return the merged segment indicator associated with the particular tour reservation if applicable.
     * - use: optional
     * @var string
     */
    public $MergedSegmentInd;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: "NumberInParty" is used to return the number of passengers associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $NumberInParty;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on Cruise - DestinationLocation - ArrivalDate, Cruise - DestinationLocation - ArrivalTime, Cruise - DestinationLocation - @LocationCode.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: "Id" is used to return the id of Cruise (BasData)
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Cruise
     * @uses Cruise::setBerth()
     * @uses Cruise::setCabin()
     * @uses Cruise::setCarRate()
     * @uses Cruise::setConfirmationNumber()
     * @uses Cruise::setDestinationLocation()
     * @uses Cruise::setOriginLocation()
     * @uses Cruise::setPassenger()
     * @uses Cruise::setSeat()
     * @uses Cruise::setServiceInformation()
     * @uses Cruise::setShipName()
     * @uses Cruise::setSpaceReserved()
     * @uses Cruise::setText()
     * @uses Cruise::setTotalFare()
     * @uses Cruise::setTrailerPrice()
     * @uses Cruise::setVendor()
     * @uses Cruise::setDayOfWeekInd()
     * @uses Cruise::setLinkCode()
     * @uses Cruise::setMergedSegmentInd()
     * @uses Cruise::setNumberInParty()
     * @uses Cruise::setSegmentNumber()
     * @uses Cruise::setStatus()
     * @uses Cruise::setType()
     * @uses Cruise::setIsPast()
     * @uses Cruise::setId()
     * @param string[] $berth
     * @param string[] $cabin
     * @param string[] $carRate
     * @param string[] $confirmationNumber
     * @param \Sabre\TravelItineraryRead\Structs\DestinationLocation $destinationLocation
     * @param \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation
     * @param string[] $passenger
     * @param string[] $seat
     * @param \Sabre\TravelItineraryRead\Structs\ServiceInformation $serviceInformation
     * @param string[] $shipName
     * @param string[] $spaceReserved
     * @param string[] $text
     * @param string[] $totalFare
     * @param string[] $trailerPrice
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @param string $dayOfWeekInd
     * @param string $linkCode
     * @param string $mergedSegmentInd
     * @param string $numberInParty
     * @param string $segmentNumber
     * @param string $status
     * @param string $type
     * @param bool $isPast
     * @param string $id
     */
    public function __construct(array $berth = array(), array $cabin = array(), array $carRate = array(), array $confirmationNumber = array(), \Sabre\TravelItineraryRead\Structs\DestinationLocation $destinationLocation = null, \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation = null, array $passenger = array(), array $seat = array(), \Sabre\TravelItineraryRead\Structs\ServiceInformation $serviceInformation = null, array $shipName = array(), array $spaceReserved = array(), array $text = array(), array $totalFare = array(), array $trailerPrice = array(), \Sabre\TravelItineraryRead\Structs\Vendor $vendor = null, $dayOfWeekInd = null, $linkCode = null, $mergedSegmentInd = null, $numberInParty = null, $segmentNumber = null, $status = null, $type = null, $isPast = null, $id = null)
    {
        $this
            ->setBerth($berth)
            ->setCabin($cabin)
            ->setCarRate($carRate)
            ->setConfirmationNumber($confirmationNumber)
            ->setDestinationLocation($destinationLocation)
            ->setOriginLocation($originLocation)
            ->setPassenger($passenger)
            ->setSeat($seat)
            ->setServiceInformation($serviceInformation)
            ->setShipName($shipName)
            ->setSpaceReserved($spaceReserved)
            ->setText($text)
            ->setTotalFare($totalFare)
            ->setTrailerPrice($trailerPrice)
            ->setVendor($vendor)
            ->setDayOfWeekInd($dayOfWeekInd)
            ->setLinkCode($linkCode)
            ->setMergedSegmentInd($mergedSegmentInd)
            ->setNumberInParty($numberInParty)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status)
            ->setType($type)
            ->setIsPast($isPast)
            ->setId($id);
    }
    /**
     * Get Berth value
     * @return string[]|null
     */
    public function getBerth()
    {
        return $this->Berth;
    }
    /**
     * Set Berth value
     * @throws \InvalidArgumentException
     * @param string[] $berth
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setBerth(array $berth = array())
    {
        $this->Berth = $berth;
        return $this;
    }
    /**
     * Add item to Berth value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToBerth($item)
    {
        $this->Berth[] = $item;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string[]|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @throws \InvalidArgumentException
     * @param string[] $cabin
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setCabin(array $cabin = array())
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Add item to Cabin value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToCabin($item)
    {
        $this->Cabin[] = $item;
        return $this;
    }
    /**
     * Get CarRate value
     * @return string[]|null
     */
    public function getCarRate()
    {
        return $this->CarRate;
    }
    /**
     * Set CarRate value
     * @throws \InvalidArgumentException
     * @param string[] $carRate
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setCarRate(array $carRate = array())
    {
        $this->CarRate = $carRate;
        return $this;
    }
    /**
     * Add item to CarRate value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToCarRate($item)
    {
        $this->CarRate[] = $item;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string[]|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param string[] $confirmationNumber
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setConfirmationNumber(array $confirmationNumber = array())
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Add item to ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToConfirmationNumber($item)
    {
        $this->ConfirmationNumber[] = $item;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\TravelItineraryRead\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setDestinationLocation(\Sabre\TravelItineraryRead\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\TravelItineraryRead\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setOriginLocation(\Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get Passenger value
     * @return string[]|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @throws \InvalidArgumentException
     * @param string[] $passenger
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setPassenger(array $passenger = array())
    {
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Add item to Passenger value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToPassenger($item)
    {
        $this->Passenger[] = $item;
        return $this;
    }
    /**
     * Get Seat value
     * @return string[]|null
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @throws \InvalidArgumentException
     * @param string[] $seat
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setSeat(array $seat = array())
    {
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Add item to Seat value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToSeat($item)
    {
        $this->Seat[] = $item;
        return $this;
    }
    /**
     * Get ServiceInformation value
     * @return \Sabre\TravelItineraryRead\Structs\ServiceInformation|null
     */
    public function getServiceInformation()
    {
        return $this->ServiceInformation;
    }
    /**
     * Set ServiceInformation value
     * @param \Sabre\TravelItineraryRead\Structs\ServiceInformation $serviceInformation
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setServiceInformation(\Sabre\TravelItineraryRead\Structs\ServiceInformation $serviceInformation = null)
    {
        $this->ServiceInformation = $serviceInformation;
        return $this;
    }
    /**
     * Get ShipName value
     * @return string[]|null
     */
    public function getShipName()
    {
        return $this->ShipName;
    }
    /**
     * Set ShipName value
     * @throws \InvalidArgumentException
     * @param string[] $shipName
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setShipName(array $shipName = array())
    {
        $this->ShipName = $shipName;
        return $this;
    }
    /**
     * Add item to ShipName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToShipName($item)
    {
        $this->ShipName[] = $item;
        return $this;
    }
    /**
     * Get SpaceReserved value
     * @return string[]|null
     */
    public function getSpaceReserved()
    {
        return $this->SpaceReserved;
    }
    /**
     * Set SpaceReserved value
     * @throws \InvalidArgumentException
     * @param string[] $spaceReserved
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setSpaceReserved(array $spaceReserved = array())
    {
        $this->SpaceReserved = $spaceReserved;
        return $this;
    }
    /**
     * Add item to SpaceReserved value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToSpaceReserved($item)
    {
        $this->SpaceReserved[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return string[]|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @throws \InvalidArgumentException
     * @param string[] $totalFare
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setTotalFare(array $totalFare = array())
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Add item to TotalFare value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToTotalFare($item)
    {
        $this->TotalFare[] = $item;
        return $this;
    }
    /**
     * Get TrailerPrice value
     * @return string[]|null
     */
    public function getTrailerPrice()
    {
        return $this->TrailerPrice;
    }
    /**
     * Set TrailerPrice value
     * @throws \InvalidArgumentException
     * @param string[] $trailerPrice
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setTrailerPrice(array $trailerPrice = array())
    {
        $this->TrailerPrice = $trailerPrice;
        return $this;
    }
    /**
     * Add item to TrailerPrice value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function addToTrailerPrice($item)
    {
        $this->TrailerPrice[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\TravelItineraryRead\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setVendor(\Sabre\TravelItineraryRead\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get DayOfWeekInd value
     * @return string|null
     */
    public function getDayOfWeekInd()
    {
        return $this->DayOfWeekInd;
    }
    /**
     * Set DayOfWeekInd value
     * @param string $dayOfWeekInd
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setDayOfWeekInd($dayOfWeekInd = null)
    {
        $this->DayOfWeekInd = $dayOfWeekInd;
        return $this;
    }
    /**
     * Get LinkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->LinkCode;
    }
    /**
     * Set LinkCode value
     * @param string $linkCode
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setLinkCode($linkCode = null)
    {
        $this->LinkCode = $linkCode;
        return $this;
    }
    /**
     * Get MergedSegmentInd value
     * @return string|null
     */
    public function getMergedSegmentInd()
    {
        return $this->MergedSegmentInd;
    }
    /**
     * Set MergedSegmentInd value
     * @param string $mergedSegmentInd
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setMergedSegmentInd($mergedSegmentInd = null)
    {
        $this->MergedSegmentInd = $mergedSegmentInd;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return string|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param string $numberInParty
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Cruise
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
