<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coverages Structs
 * @subpackage Structs
 */
class Coverages extends AbstractStructBase
{
    /**
     * The Coverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\InsuranceCoverage[]
     */
    public $Coverage;
    /**
     * Constructor method for Coverages
     * @uses Coverages::setCoverage()
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceCoverage[] $coverage
     */
    public function __construct(array $coverage = array())
    {
        $this
            ->setCoverage($coverage);
    }
    /**
     * Get Coverage value
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceCoverage[]|null
     */
    public function getCoverage()
    {
        return $this->Coverage;
    }
    /**
     * Set Coverage value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceCoverage[] $coverage
     * @return \Sabre\TravelItineraryRead\Structs\Coverages
     */
    public function setCoverage(array $coverage = array())
    {
        $this->Coverage = $coverage;
        return $this;
    }
    /**
     * Add item to Coverage value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceCoverage $item
     * @return \Sabre\TravelItineraryRead\Structs\Coverages
     */
    public function addToCoverage(\Sabre\TravelItineraryRead\Structs\InsuranceCoverage $item)
    {
        $this->Coverage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Coverages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
