<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coverage Structs
 * @subpackage Structs
 */
class Coverage extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the coverage amount associated with the particular insurance segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Amount;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the coverage type associated with the particular insurance segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Type;
    /**
     * Constructor method for Coverage
     * @uses Coverage::setAmount()
     * @uses Coverage::setType()
     * @param string[] $amount
     * @param string[] $type
     */
    public function __construct(array $amount = array(), array $type = array())
    {
        $this
            ->setAmount($amount)
            ->setType($type);
    }
    /**
     * Get Amount value
     * @return string[]|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @throws \InvalidArgumentException
     * @param string[] $amount
     * @return \Sabre\TravelItineraryRead\Structs\Coverage
     */
    public function setAmount(array $amount = array())
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Add item to Amount value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Coverage
     */
    public function addToAmount($item)
    {
        $this->Amount[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string[]|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \Sabre\TravelItineraryRead\Structs\Coverage
     */
    public function setType(array $type = array())
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Add item to Type value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\Coverage
     */
    public function addToType($item)
    {
        $this->Type[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Coverage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
