<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancellationPolicyInfoList Structs
 * Meta informations extracted from the WSDL
 * - documentation: Details specifics of the cancellation policy, typically the times determining the penalty period and the penalties incurred for cancellation.
 * @subpackage Structs
 */
class CancellationPolicyInfoList extends AbstractStructBase
{
    /**
     * The CancelPolicyInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * @var \Sabre\TravelItineraryRead\Structs\CancelPolicyInfo[]
     */
    public $CancelPolicyInfo;
    /**
     * Constructor method for CancellationPolicyInfoList
     * @uses CancellationPolicyInfoList::setCancelPolicyInfo()
     * @param \Sabre\TravelItineraryRead\Structs\CancelPolicyInfo[] $cancelPolicyInfo
     */
    public function __construct(array $cancelPolicyInfo = array())
    {
        $this
            ->setCancelPolicyInfo($cancelPolicyInfo);
    }
    /**
     * Get CancelPolicyInfo value
     * @return \Sabre\TravelItineraryRead\Structs\CancelPolicyInfo[]|null
     */
    public function getCancelPolicyInfo()
    {
        return $this->CancelPolicyInfo;
    }
    /**
     * Set CancelPolicyInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\CancelPolicyInfo[] $cancelPolicyInfo
     * @return \Sabre\TravelItineraryRead\Structs\CancellationPolicyInfoList
     */
    public function setCancelPolicyInfo(array $cancelPolicyInfo = array())
    {
        $this->CancelPolicyInfo = $cancelPolicyInfo;
        return $this;
    }
    /**
     * Add item to CancelPolicyInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\CancelPolicyInfo $item
     * @return \Sabre\TravelItineraryRead\Structs\CancellationPolicyInfoList
     */
    public function addToCancelPolicyInfo(\Sabre\TravelItineraryRead\Structs\CancelPolicyInfo $item)
    {
        $this->CancelPolicyInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\CancellationPolicyInfoList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
