<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyFeesType Structs
 * @subpackage Structs
 */
class AgencyFeesType extends AbstractStructBase
{
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - minLength: 1
     * @var string
     */
    public $PassengerType;
    /**
     * The NumberOfPassengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfPassengers;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $Date;
    /**
     * The FeeDescription
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $FeeDescription;
    /**
     * The RuleLineDescription
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $RuleLineDescription;
    /**
     * The RuleDetails
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $RuleDetails;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $Status;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Tax;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for AgencyFeesType
     * @uses AgencyFeesType::setPassengerType()
     * @uses AgencyFeesType::setNumberOfPassengers()
     * @uses AgencyFeesType::setDate()
     * @uses AgencyFeesType::setFeeDescription()
     * @uses AgencyFeesType::setRuleLineDescription()
     * @uses AgencyFeesType::setRuleDetails()
     * @uses AgencyFeesType::setStatus()
     * @uses AgencyFeesType::setAmount()
     * @uses AgencyFeesType::setTax()
     * @uses AgencyFeesType::setCurrency()
     * @param string $passengerType
     * @param int $numberOfPassengers
     * @param string $date
     * @param string $feeDescription
     * @param string $ruleLineDescription
     * @param string $ruleDetails
     * @param string $status
     * @param float $amount
     * @param float $tax
     * @param string $currency
     */
    public function __construct($passengerType = null, $numberOfPassengers = null, $date = null, $feeDescription = null, $ruleLineDescription = null, $ruleDetails = null, $status = null, $amount = null, $tax = null, $currency = null)
    {
        $this
            ->setPassengerType($passengerType)
            ->setNumberOfPassengers($numberOfPassengers)
            ->setDate($date)
            ->setFeeDescription($feeDescription)
            ->setRuleLineDescription($ruleLineDescription)
            ->setRuleDetails($ruleDetails)
            ->setStatus($status)
            ->setAmount($amount)
            ->setTax($tax)
            ->setCurrency($currency);
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setPassengerType($passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get NumberOfPassengers value
     * @return int|null
     */
    public function getNumberOfPassengers()
    {
        return $this->NumberOfPassengers;
    }
    /**
     * Set NumberOfPassengers value
     * @param int $numberOfPassengers
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setNumberOfPassengers($numberOfPassengers = null)
    {
        $this->NumberOfPassengers = $numberOfPassengers;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setDate($date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get FeeDescription value
     * @return string|null
     */
    public function getFeeDescription()
    {
        return $this->FeeDescription;
    }
    /**
     * Set FeeDescription value
     * @param string $feeDescription
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setFeeDescription($feeDescription = null)
    {
        $this->FeeDescription = $feeDescription;
        return $this;
    }
    /**
     * Get RuleLineDescription value
     * @return string|null
     */
    public function getRuleLineDescription()
    {
        return $this->RuleLineDescription;
    }
    /**
     * Set RuleLineDescription value
     * @param string $ruleLineDescription
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setRuleLineDescription($ruleLineDescription = null)
    {
        $this->RuleLineDescription = $ruleLineDescription;
        return $this;
    }
    /**
     * Get RuleDetails value
     * @return string|null
     */
    public function getRuleDetails()
    {
        return $this->RuleDetails;
    }
    /**
     * Set RuleDetails value
     * @param string $ruleDetails
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setRuleDetails($ruleDetails = null)
    {
        $this->RuleDetails = $ruleDetails;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Tax value
     * @return float|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setTax($tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
