<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingTransactionItem Structs
 * @subpackage Structs
 */
class AccountingTransactionItem extends AbstractStructBase
{
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Sabre\TravelItineraryRead\Structs\AccountingTransactionSource
     */
    public $Source;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmountWithRule[]
     */
    public $Price;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Tax[]
     */
    public $Tax;
    /**
     * The Promotion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Promotion[]
     */
    public $Promotion;
    /**
     * The AppliedAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount[]
     */
    public $AppliedAmount;
    /**
     * The Passenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\NameAssociationTag[]
     */
    public $Passenger;
    /**
     * Constructor method for AccountingTransactionItem
     * @uses AccountingTransactionItem::setSource()
     * @uses AccountingTransactionItem::setPrice()
     * @uses AccountingTransactionItem::setTax()
     * @uses AccountingTransactionItem::setPromotion()
     * @uses AccountingTransactionItem::setAppliedAmount()
     * @uses AccountingTransactionItem::setPassenger()
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionSource $source
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmountWithRule[] $price
     * @param \Sabre\TravelItineraryRead\Structs\Tax[] $tax
     * @param \Sabre\TravelItineraryRead\Structs\Promotion[] $promotion
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount[] $appliedAmount
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationTag[] $passenger
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\AccountingTransactionSource $source = null, array $price = array(), array $tax = array(), array $promotion = array(), array $appliedAmount = array(), array $passenger = array())
    {
        $this
            ->setSource($source)
            ->setPrice($price)
            ->setTax($tax)
            ->setPromotion($promotion)
            ->setAppliedAmount($appliedAmount)
            ->setPassenger($passenger);
    }
    /**
     * Get Source value
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionSource
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionSource $source
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function setSource(\Sabre\TravelItineraryRead\Structs\AccountingTransactionSource $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Price value
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmountWithRule[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmountWithRule[] $price
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function setPrice(array $price = array())
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmountWithRule $item
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function addToPrice(\Sabre\TravelItineraryRead\Structs\AccountingTransactionAmountWithRule $item)
    {
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\TravelItineraryRead\Structs\Tax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Tax[] $tax
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Tax $item
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function addToTax(\Sabre\TravelItineraryRead\Structs\Tax $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get Promotion value
     * @return \Sabre\TravelItineraryRead\Structs\Promotion[]|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Promotion[] $promotion
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function setPromotion(array $promotion = array())
    {
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Promotion $item
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function addToPromotion(\Sabre\TravelItineraryRead\Structs\Promotion $item)
    {
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Get AppliedAmount value
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount[]|null
     */
    public function getAppliedAmount()
    {
        return $this->AppliedAmount;
    }
    /**
     * Set AppliedAmount value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount[] $appliedAmount
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function setAppliedAmount(array $appliedAmount = array())
    {
        $this->AppliedAmount = $appliedAmount;
        return $this;
    }
    /**
     * Add item to AppliedAmount value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount $item
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function addToAppliedAmount(\Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount $item)
    {
        $this->AppliedAmount[] = $item;
        return $this;
    }
    /**
     * Get Passenger value
     * @return \Sabre\TravelItineraryRead\Structs\NameAssociationTag[]|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationTag[] $passenger
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function setPassenger(array $passenger = array())
    {
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Add item to Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationTag $item
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public function addToPassenger(\Sabre\TravelItineraryRead\Structs\NameAssociationTag $item)
    {
        $this->Passenger[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
