<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalTaxes Structs
 * Meta informations extracted from the WSDL
 * - documentation: "TotalTaxes" element is used as a container for taxes associated with particular ancillary.
 * @subpackage Structs
 */
class TotalTaxes extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Tax[]
     */
    public $Tax;
    /**
     * Constructor method for TotalTaxes
     * @uses TotalTaxes::setTax()
     * @param \Sabre\EnhancedAirBook\Structs\Tax[] $tax
     */
    public function __construct(array $tax = array())
    {
        $this
            ->setTax($tax);
    }
    /**
     * Get Tax value
     * @return \Sabre\EnhancedAirBook\Structs\Tax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Tax[] $tax
     * @return \Sabre\EnhancedAirBook\Structs\TotalTaxes
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Tax $item
     * @return \Sabre\EnhancedAirBook\Structs\TotalTaxes
     */
    public function addToTax(\Sabre\EnhancedAirBook\Structs\Tax $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\TotalTaxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
