<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing Structs
 * @subpackage Structs
 */
class Ticketing extends AbstractStructBase
{
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $LocationCode;
    /**
     * The EndNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $EndNumber;
    /**
     * The eTicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: "eTicketNumber" is used to return ticket-related information.
     * - use: optional
     * @var int
     */
    public $eTicketNumber;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * The Coupon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Coupon[]
     */
    public $Coupon;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public $PersonName;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The ConjunctedCount
     * Meta informations extracted from the WSDL
     * - documentation: "ConjunctedCount" is used to return the number of conjuncted eTicket coupons associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $ConjunctedCount;
    /**
     * The CouponCount
     * Meta informations extracted from the WSDL
     * - documentation: "CouponCount" is used to return the number of eTicket coupons associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $CouponCount;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference place holder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The TicketTimeLimit
     * Meta informations extracted from the WSDL
     * - documentation: "TicketTimeLimit" is used to return the ticket time limit-related information.
     * - use: optional
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "TicketStatus" is used to return the status of a ticketing document from T2.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Ticketing
     * @uses Ticketing::setLocationCode()
     * @uses Ticketing::setEndNumber()
     * @uses Ticketing::setETicketNumber()
     * @uses Ticketing::setNumber()
     * @uses Ticketing::setCoupon()
     * @uses Ticketing::setPersonName()
     * @uses Ticketing::setReferenceNumber()
     * @uses Ticketing::setConjunctedCount()
     * @uses Ticketing::setCouponCount()
     * @uses Ticketing::setRPH()
     * @uses Ticketing::setTicketTimeLimit()
     * @uses Ticketing::setId()
     * @uses Ticketing::setStatus()
     * @param string $locationCode
     * @param int $endNumber
     * @param int $eTicketNumber
     * @param int $number
     * @param \Sabre\EnhancedAirBook\Structs\Coupon[] $coupon
     * @param \Sabre\EnhancedAirBook\Structs\PersonName $personName
     * @param string $referenceNumber
     * @param string $conjunctedCount
     * @param string $couponCount
     * @param string $rPH
     * @param string $ticketTimeLimit
     * @param string $id
     * @param string $status
     */
    public function __construct($locationCode = null, $endNumber = null, $eTicketNumber = null, $number = null, array $coupon = array(), \Sabre\EnhancedAirBook\Structs\PersonName $personName = null, $referenceNumber = null, $conjunctedCount = null, $couponCount = null, $rPH = null, $ticketTimeLimit = null, $id = null, $status = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setEndNumber($endNumber)
            ->setETicketNumber($eTicketNumber)
            ->setNumber($number)
            ->setCoupon($coupon)
            ->setPersonName($personName)
            ->setReferenceNumber($referenceNumber)
            ->setConjunctedCount($conjunctedCount)
            ->setCouponCount($couponCount)
            ->setRPH($rPH)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setId($id)
            ->setStatus($status);
    }
    /**
     * Get LocationCode value
     * @return string
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get EndNumber value
     * @return int|null
     */
    public function getEndNumber()
    {
        return $this->EndNumber;
    }
    /**
     * Set EndNumber value
     * @param int $endNumber
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setEndNumber($endNumber = null)
    {
        $this->EndNumber = $endNumber;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return int|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param int $eTicketNumber
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Coupon value
     * @return \Sabre\EnhancedAirBook\Structs\Coupon[]|null
     */
    public function getCoupon()
    {
        return $this->Coupon;
    }
    /**
     * Set Coupon value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Coupon[] $coupon
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setCoupon(array $coupon = array())
    {
        $this->Coupon = $coupon;
        return $this;
    }
    /**
     * Add item to Coupon value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Coupon $item
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function addToCoupon(\Sabre\EnhancedAirBook\Structs\Coupon $item)
    {
        $this->Coupon[] = $item;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\EnhancedAirBook\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\EnhancedAirBook\Structs\PersonName $personName
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setPersonName(\Sabre\EnhancedAirBook\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ConjunctedCount value
     * @return string|null
     */
    public function getConjunctedCount()
    {
        return $this->ConjunctedCount;
    }
    /**
     * Set ConjunctedCount value
     * @param string $conjunctedCount
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setConjunctedCount($conjunctedCount = null)
    {
        $this->ConjunctedCount = $conjunctedCount;
        return $this;
    }
    /**
     * Get CouponCount value
     * @return string|null
     */
    public function getCouponCount()
    {
        return $this->CouponCount;
    }
    /**
     * Set CouponCount value
     * @param string $couponCount
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setCouponCount($couponCount = null)
    {
        $this->CouponCount = $couponCount;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
