<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceProviderType Structs
 * @subpackage Structs
 */
class ServiceProviderType extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Code
     */
    public $Code;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PhoneType[]
     */
    public $Telephone;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AddressType[]
     */
    public $Address;
    /**
     * Constructor method for ServiceProviderType
     * @uses ServiceProviderType::setName()
     * @uses ServiceProviderType::setCode()
     * @uses ServiceProviderType::setTelephone()
     * @uses ServiceProviderType::setAddress()
     * @param string $name
     * @param \Sabre\EnhancedAirBook\Structs\Code $code
     * @param \Sabre\EnhancedAirBook\Structs\PhoneType[] $telephone
     * @param \Sabre\EnhancedAirBook\Structs\AddressType[] $address
     */
    public function __construct($name = null, \Sabre\EnhancedAirBook\Structs\Code $code = null, array $telephone = array(), array $address = array())
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setTelephone($telephone)
            ->setAddress($address);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\EnhancedAirBook\Structs\ServiceProviderType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return \Sabre\EnhancedAirBook\Structs\Code|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param \Sabre\EnhancedAirBook\Structs\Code $code
     * @return \Sabre\EnhancedAirBook\Structs\ServiceProviderType
     */
    public function setCode(\Sabre\EnhancedAirBook\Structs\Code $code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\EnhancedAirBook\Structs\PhoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PhoneType[] $telephone
     * @return \Sabre\EnhancedAirBook\Structs\ServiceProviderType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PhoneType $item
     * @return \Sabre\EnhancedAirBook\Structs\ServiceProviderType
     */
    public function addToTelephone(\Sabre\EnhancedAirBook\Structs\PhoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\EnhancedAirBook\Structs\AddressType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\AddressType[] $address
     * @return \Sabre\EnhancedAirBook\Structs\ServiceProviderType
     */
    public function setAddress(array $address = array())
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\AddressType $item
     * @return \Sabre\EnhancedAirBook\Structs\ServiceProviderType
     */
    public function addToAddress(\Sabre\EnhancedAirBook\Structs\AddressType $item)
    {
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\ServiceProviderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
