<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service Structs
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Name;
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Airline
     */
    public $Airline;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous SSR-related free text if applicable
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The SSR_Code
     * Meta informations extracted from the WSDL
     * - documentation: "SSR_Code is used to return the SSR code associated with the particular SSR segment
     * - use: optional
     * @var string
     */
    public $SSR_Code;
    /**
     * The SSR_Type
     * Meta informations extracted from the WSDL
     * - documentation: "SSR_Type" is used to return the SSR type associated with the particular SSR segment Example: WCHR
     * - use: optional
     * @var string
     */
    public $SSR_Type;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $type;
    /**
     * Constructor method for Service
     * @uses Service::setName()
     * @uses Service::setAirline()
     * @uses Service::setPersonName()
     * @uses Service::setText()
     * @uses Service::setSSR_Code()
     * @uses Service::setSSR_Type()
     * @uses Service::set_()
     * @uses Service::setType()
     * @param string $name
     * @param \Sabre\EnhancedAirBook\Structs\Airline $airline
     * @param \Sabre\EnhancedAirBook\Structs\PersonName[] $personName
     * @param string[] $text
     * @param string $sSR_Code
     * @param string $sSR_Type
     * @param string $_
     * @param string $type
     */
    public function __construct($name = null, \Sabre\EnhancedAirBook\Structs\Airline $airline = null, array $personName = array(), array $text = array(), $sSR_Code = null, $sSR_Type = null, $_ = null, $type = null)
    {
        $this
            ->setName($name)
            ->setAirline($airline)
            ->setPersonName($personName)
            ->setText($text)
            ->setSSR_Code($sSR_Code)
            ->setSSR_Type($sSR_Type)
            ->set_($_)
            ->setType($type);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Airline value
     * @return \Sabre\EnhancedAirBook\Structs\Airline|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \Sabre\EnhancedAirBook\Structs\Airline $airline
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function setAirline(\Sabre\EnhancedAirBook\Structs\Airline $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\EnhancedAirBook\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PersonName[] $personName
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PersonName $item
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function addToPersonName(\Sabre\EnhancedAirBook\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get SSR_Code value
     * @return string|null
     */
    public function getSSR_Code()
    {
        return $this->SSR_Code;
    }
    /**
     * Set SSR_Code value
     * @param string $sSR_Code
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function setSSR_Code($sSR_Code = null)
    {
        $this->SSR_Code = $sSR_Code;
        return $this;
    }
    /**
     * Get SSR_Type value
     * @return string|null
     */
    public function getSSR_Type()
    {
        return $this->SSR_Type;
    }
    /**
     * Set SSR_Type value
     * @param string $sSR_Type
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function setSSR_Type($sSR_Type = null)
    {
        $this->SSR_Type = $sSR_Type;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
