<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestorSourceType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Provides information on the source of a request.
 * @subpackage Structs
 */
class RequestorSourceType extends AbstractStructBase
{
    /**
     * The ApplicationID
     * Meta informations extracted from the WSDL
     * - documentation: The identifier of the calling application that used by this requestor to submit this payload.
     * - use: required
     * @var string
     */
    public $ApplicationID;
    /**
     * The AgentSine
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity.
     * - use: optional
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system.
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The AgentDutyCode
     * Meta informations extracted from the WSDL
     * - documentation: An authority code assigned to a requestor.
     * - use: optional
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirportCode
     * Meta informations extracted from the WSDL
     * - documentation: The IATA assigned airport code.
     * - use: optional
     * @var string
     */
    public $AirportCode;
    /**
     * The TerminalID
     * Meta informations extracted from the WSDL
     * - documentation: This is the electronic address of the device from which payload is submitted.
     * - use: optional
     * @var string
     */
    public $TerminalID;
    /**
     * Constructor method for RequestorSourceType
     * @uses RequestorSourceType::setApplicationID()
     * @uses RequestorSourceType::setAgentSine()
     * @uses RequestorSourceType::setPseudoCityCode()
     * @uses RequestorSourceType::setAgentDutyCode()
     * @uses RequestorSourceType::setAirportCode()
     * @uses RequestorSourceType::setTerminalID()
     * @param string $applicationID
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $agentDutyCode
     * @param string $airportCode
     * @param string $terminalID
     */
    public function __construct($applicationID = null, $agentSine = null, $pseudoCityCode = null, $agentDutyCode = null, $airportCode = null, $terminalID = null)
    {
        $this
            ->setApplicationID($applicationID)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirportCode($airportCode)
            ->setTerminalID($terminalID);
    }
    /**
     * Get ApplicationID value
     * @return string
     */
    public function getApplicationID()
    {
        return $this->ApplicationID;
    }
    /**
     * Set ApplicationID value
     * @param string $applicationID
     * @return \Sabre\EnhancedAirBook\Structs\RequestorSourceType
     */
    public function setApplicationID($applicationID = null)
    {
        $this->ApplicationID = $applicationID;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \Sabre\EnhancedAirBook\Structs\RequestorSourceType
     */
    public function setAgentSine($agentSine = null)
    {
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\EnhancedAirBook\Structs\RequestorSourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \Sabre\EnhancedAirBook\Structs\RequestorSourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \Sabre\EnhancedAirBook\Structs\RequestorSourceType
     */
    public function setAirportCode($airportCode = null)
    {
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get TerminalID value
     * @return string|null
     */
    public function getTerminalID()
    {
        return $this->TerminalID;
    }
    /**
     * Set TerminalID value
     * @param string $terminalID
     * @return \Sabre\EnhancedAirBook\Structs\RequestorSourceType
     */
    public function setTerminalID($terminalID = null)
    {
        $this->TerminalID = $terminalID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\RequestorSourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
