<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonName Structs
 * Meta informations extracted from the WSDL
 * - documentation: PersonName is used to return the passenger name associated with the particular accounting line Example: NameNumber="1.1" TESTA TEST1" | PersonName is the passenger name | PersonName is used to return the passenger name associated
 * with the particular ticketing line Example: NameNumber="1.1" TESTA TEST1" | PersonName contains information about the passenger name | PersonName contains information about the passenger name | "PersonName" is used to return the passenger name
 * associated with the particular SSR segment if applicable
 * @subpackage Structs
 */
class PersonName extends AbstractStructBase
{
    /**
     * The GivenName
     * Meta informations extracted from the WSDL
     * - documentation: "GivenName" is used to return the passenger's given (first) name. | "GivenName" is used to return the policy holder's first name associated with the particular insurance segment.
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\GivenName
     */
    public $GivenName;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - documentation: "Surname" is used to return the passenger's last name. | "Surname" is used to return the policy holder's last name associated with the particular insurance segment.
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Surname
     */
    public $Surname;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - documentation: NameNumber is used to return the passenger name number associated with the particular passenger | "NameNumber" is used to return the passenger name number. | NameNumber is used to return the passenger name number associated with the
     * particular passenger | NameNumber is used to return the passenger name number associated with the particular passenger | NameNumber" is used to return the passenger name number associated with the particular SSR segment if applicable
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Email[]
     */
    public $Email;
    /**
     * The GroupInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\GroupInfo
     */
    public $GroupInfo;
    /**
     * The ProfileIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ProfileIndex[]
     */
    public $ProfileIndex;
    /**
     * The WithInfant
     * Meta informations extracted from the WSDL
     * - documentation: "WithInfant" is used to indicate whether or not the passenger is an infant.
     * - use: optional
     * @var string
     */
    public $WithInfant;
    /**
     * The NameReference
     * Meta informations extracted from the WSDL
     * - documentation: "NameReference" is used to return miscellaneous name reference-related information if applicable.
     * - use: optional
     * @var string
     */
    public $NameReference;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - documentation: "PassengerType" is used to return the passenger type associated with the particular passenger.
     * - use: optional
     * @var string
     */
    public $PassengerType;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference place holder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The elementId
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $elementId;
    /**
     * Constructor method for PersonName
     * @uses PersonName::setGivenName()
     * @uses PersonName::setSurname()
     * @uses PersonName::set_()
     * @uses PersonName::setNameNumber()
     * @uses PersonName::setEmail()
     * @uses PersonName::setGroupInfo()
     * @uses PersonName::setProfileIndex()
     * @uses PersonName::setWithInfant()
     * @uses PersonName::setNameReference()
     * @uses PersonName::setPassengerType()
     * @uses PersonName::setRPH()
     * @uses PersonName::setId()
     * @uses PersonName::setElementId()
     * @param \Sabre\EnhancedAirBook\Structs\GivenName $givenName
     * @param \Sabre\EnhancedAirBook\Structs\Surname $surname
     * @param string $_
     * @param string $nameNumber
     * @param \Sabre\EnhancedAirBook\Structs\Email[] $email
     * @param \Sabre\EnhancedAirBook\Structs\GroupInfo $groupInfo
     * @param \Sabre\EnhancedAirBook\Structs\ProfileIndex[] $profileIndex
     * @param string $withInfant
     * @param string $nameReference
     * @param string $passengerType
     * @param string $rPH
     * @param string $id
     * @param string $elementId
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\GivenName $givenName = null, \Sabre\EnhancedAirBook\Structs\Surname $surname = null, $_ = null, $nameNumber = null, array $email = array(), \Sabre\EnhancedAirBook\Structs\GroupInfo $groupInfo = null, array $profileIndex = array(), $withInfant = null, $nameReference = null, $passengerType = null, $rPH = null, $id = null, $elementId = null)
    {
        $this
            ->setGivenName($givenName)
            ->setSurname($surname)
            ->set_($_)
            ->setNameNumber($nameNumber)
            ->setEmail($email)
            ->setGroupInfo($groupInfo)
            ->setProfileIndex($profileIndex)
            ->setWithInfant($withInfant)
            ->setNameReference($nameReference)
            ->setPassengerType($passengerType)
            ->setRPH($rPH)
            ->setId($id)
            ->setElementId($elementId);
    }
    /**
     * Get GivenName value
     * @return \Sabre\EnhancedAirBook\Structs\GivenName|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @param \Sabre\EnhancedAirBook\Structs\GivenName $givenName
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setGivenName(\Sabre\EnhancedAirBook\Structs\GivenName $givenName = null)
    {
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Get Surname value
     * @return \Sabre\EnhancedAirBook\Structs\Surname|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param \Sabre\EnhancedAirBook\Structs\Surname $surname
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setSurname(\Sabre\EnhancedAirBook\Structs\Surname $surname = null)
    {
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get Email value
     * @return \Sabre\EnhancedAirBook\Structs\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Email[] $email
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Email $item
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function addToEmail(\Sabre\EnhancedAirBook\Structs\Email $item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get GroupInfo value
     * @return \Sabre\EnhancedAirBook\Structs\GroupInfo|null
     */
    public function getGroupInfo()
    {
        return $this->GroupInfo;
    }
    /**
     * Set GroupInfo value
     * @param \Sabre\EnhancedAirBook\Structs\GroupInfo $groupInfo
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setGroupInfo(\Sabre\EnhancedAirBook\Structs\GroupInfo $groupInfo = null)
    {
        $this->GroupInfo = $groupInfo;
        return $this;
    }
    /**
     * Get ProfileIndex value
     * @return \Sabre\EnhancedAirBook\Structs\ProfileIndex[]|null
     */
    public function getProfileIndex()
    {
        return $this->ProfileIndex;
    }
    /**
     * Set ProfileIndex value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ProfileIndex[] $profileIndex
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setProfileIndex(array $profileIndex = array())
    {
        $this->ProfileIndex = $profileIndex;
        return $this;
    }
    /**
     * Add item to ProfileIndex value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ProfileIndex $item
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function addToProfileIndex(\Sabre\EnhancedAirBook\Structs\ProfileIndex $item)
    {
        $this->ProfileIndex[] = $item;
        return $this;
    }
    /**
     * Get WithInfant value
     * @return string|null
     */
    public function getWithInfant()
    {
        return $this->WithInfant;
    }
    /**
     * Set WithInfant value
     * @param string $withInfant
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setWithInfant($withInfant = null)
    {
        $this->WithInfant = $withInfant;
        return $this;
    }
    /**
     * Get NameReference value
     * @return string|null
     */
    public function getNameReference()
    {
        return $this->NameReference;
    }
    /**
     * Set NameReference value
     * @param string $nameReference
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setNameReference($nameReference = null)
    {
        $this->NameReference = $nameReference;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setPassengerType($passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get elementId value
     * @return string|null
     */
    public function getElementId()
    {
        return $this->elementId;
    }
    /**
     * Set elementId value
     * @param string $elementId
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public function setElementId($elementId = null)
    {
        $this->elementId = $elementId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PersonName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
