<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment Structs
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The CC_Info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CC_Info[]
     */
    public $CC_Info;
    /**
     * The Form
     * Meta informations extracted from the WSDL
     * - documentation: "Form" is used to return the form of payment used to purchase the insurance.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string
     */
    public $Form;
    /**
     * Constructor method for Payment
     * @uses Payment::setCC_Info()
     * @uses Payment::setForm()
     * @param \Sabre\EnhancedAirBook\Structs\CC_Info[] $cC_Info
     * @param string $form
     */
    public function __construct(array $cC_Info = array(), $form = null)
    {
        $this
            ->setCC_Info($cC_Info)
            ->setForm($form);
    }
    /**
     * Get CC_Info value
     * @return \Sabre\EnhancedAirBook\Structs\CC_Info[]|null
     */
    public function getCC_Info()
    {
        return $this->CC_Info;
    }
    /**
     * Set CC_Info value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CC_Info[] $cC_Info
     * @return \Sabre\EnhancedAirBook\Structs\Payment
     */
    public function setCC_Info(array $cC_Info = array())
    {
        $this->CC_Info = $cC_Info;
        return $this;
    }
    /**
     * Add item to CC_Info value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CC_Info $item
     * @return \Sabre\EnhancedAirBook\Structs\Payment
     */
    public function addToCC_Info(\Sabre\EnhancedAirBook\Structs\CC_Info $item)
    {
        $this->CC_Info[] = $item;
        return $this;
    }
    /**
     * Get Form value
     * @return string|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param string $form
     * @return \Sabre\EnhancedAirBook\Structs\Payment
     */
    public function setForm($form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
