<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passengers Structs
 * @subpackage Structs
 */
class Passengers extends AbstractStructBase
{
    /**
     * The Passenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PassengerType[]
     */
    public $Passenger;
    /**
     * The quantity
     * @var string
     */
    public $quantity;
    /**
     * Constructor method for Passengers
     * @uses Passengers::setPassenger()
     * @uses Passengers::setQuantity()
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType[] $passenger
     * @param string $quantity
     */
    public function __construct(array $passenger = array(), $quantity = null)
    {
        $this
            ->setPassenger($passenger)
            ->setQuantity($quantity);
    }
    /**
     * Get Passenger value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType[]|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType[] $passenger
     * @return \Sabre\EnhancedAirBook\Structs\Passengers
     */
    public function setPassenger(array $passenger = array())
    {
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Add item to Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType $item
     * @return \Sabre\EnhancedAirBook\Structs\Passengers
     */
    public function addToPassenger(\Sabre\EnhancedAirBook\Structs\PassengerType $item)
    {
        $this->Passenger[] = $item;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \Sabre\EnhancedAirBook\Structs\Passengers
     */
    public function setQuantity($quantity = null)
    {
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Passengers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
