<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerType Structs
 * @subpackage Structs
 */
class PassengerType extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Age;
    /**
     * The Force
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Force;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $Total;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Type
     */
    public $Type;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PhoneType[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $Email;
    /**
     * The passengerID
     * @var string
     */
    public $passengerID;
    /**
     * The primary
     * @var bool
     */
    public $primary;
    /**
     * Constructor method for PassengerType
     * @uses PassengerType::setQuantity()
     * @uses PassengerType::setCode()
     * @uses PassengerType::setAge()
     * @uses PassengerType::setForce()
     * @uses PassengerType::setTotal()
     * @uses PassengerType::setType()
     * @uses PassengerType::setPersonName()
     * @uses PassengerType::setTelephone()
     * @uses PassengerType::setEmail()
     * @uses PassengerType::setPassengerID()
     * @uses PassengerType::setPrimary()
     * @param int $quantity
     * @param string $code
     * @param int $age
     * @param bool $force
     * @param float $total
     * @param \Sabre\EnhancedAirBook\Structs\Type $type
     * @param \Sabre\EnhancedAirBook\Structs\PersonNameType $personName
     * @param \Sabre\EnhancedAirBook\Structs\PhoneType[] $telephone
     * @param string[] $email
     * @param string $passengerID
     * @param bool $primary
     */
    public function __construct($quantity = null, $code = null, $age = null, $force = null, $total = null, \Sabre\EnhancedAirBook\Structs\Type $type = null, \Sabre\EnhancedAirBook\Structs\PersonNameType $personName = null, array $telephone = array(), array $email = array(), $passengerID = null, $primary = null)
    {
        $this
            ->setQuantity($quantity)
            ->setCode($code)
            ->setAge($age)
            ->setForce($force)
            ->setTotal($total)
            ->setType($type)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setPassengerID($passengerID)
            ->setPrimary($primary);
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setAge($age = null)
    {
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Force value
     * @return bool|null
     */
    public function getForce()
    {
        return $this->Force;
    }
    /**
     * Set Force value
     * @param bool $force
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setForce($force = null)
    {
        $this->Force = $force;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Type value
     * @return \Sabre\EnhancedAirBook\Structs\Type|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Sabre\EnhancedAirBook\Structs\Type $type
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setType(\Sabre\EnhancedAirBook\Structs\Type $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\EnhancedAirBook\Structs\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\EnhancedAirBook\Structs\PersonNameType $personName
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setPersonName(\Sabre\EnhancedAirBook\Structs\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\EnhancedAirBook\Structs\PhoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PhoneType[] $telephone
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PhoneType $item
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function addToTelephone(\Sabre\EnhancedAirBook\Structs\PhoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return string[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function addToEmail($item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get passengerID value
     * @return string|null
     */
    public function getPassengerID()
    {
        return $this->passengerID;
    }
    /**
     * Set passengerID value
     * @param string $passengerID
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setPassengerID($passengerID = null)
    {
        $this->passengerID = $passengerID;
        return $this;
    }
    /**
     * Get primary value
     * @return bool|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param bool $primary
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public function setPrimary($primary = null)
    {
        $this->primary = $primary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
