<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerInfo Structs
 * @subpackage Structs
 */
class PassengerInfo extends AbstractStructBase
{
    /**
     * The PassengerData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PassengerData[]
     */
    public $PassengerData;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - documentation: "PassengerType" is used to return PAX type for particular fare component.
     * - use: optional
     * @var string
     */
    public $PassengerType;
    /**
     * Constructor method for PassengerInfo
     * @uses PassengerInfo::setPassengerData()
     * @uses PassengerInfo::setPassengerType()
     * @param \Sabre\EnhancedAirBook\Structs\PassengerData[] $passengerData
     * @param string $passengerType
     */
    public function __construct(array $passengerData = array(), $passengerType = null)
    {
        $this
            ->setPassengerData($passengerData)
            ->setPassengerType($passengerType);
    }
    /**
     * Get PassengerData value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerData[]|null
     */
    public function getPassengerData()
    {
        return $this->PassengerData;
    }
    /**
     * Set PassengerData value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerData[] $passengerData
     * @return \Sabre\EnhancedAirBook\Structs\PassengerInfo
     */
    public function setPassengerData(array $passengerData = array())
    {
        $this->PassengerData = $passengerData;
        return $this;
    }
    /**
     * Add item to PassengerData value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerData $item
     * @return \Sabre\EnhancedAirBook\Structs\PassengerInfo
     */
    public function addToPassengerData(\Sabre\EnhancedAirBook\Structs\PassengerData $item)
    {
        $this->PassengerData[] = $item;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \Sabre\EnhancedAirBook\Structs\PassengerInfo
     */
    public function setPassengerType($passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PassengerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
