<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location Structs
 * @subpackage Structs
 */
class Location extends AbstractStructBase
{
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - documentation: "Origin" is used to return first city of particular Fare Component.
     * - use: optional
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - documentation: "Destination" is used to return last city of particular Fare Component.
     * - use: optional
     * @var string
     */
    public $Destination;
    /**
     * Constructor method for Location
     * @uses Location::setOrigin()
     * @uses Location::setDestination()
     * @param string $origin
     * @param string $destination
     */
    public function __construct($origin = null, $destination = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination);
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \Sabre\EnhancedAirBook\Structs\Location
     */
    public function setOrigin($origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \Sabre\EnhancedAirBook\Structs\Location
     */
    public function setDestination($destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Location
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
