<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryInfo Structs
 * @subpackage Structs
 */
class ItineraryInfo extends AbstractStructBase
{
    /**
     * The ReservationItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ReservationItems
     */
    public $ReservationItems;
    /**
     * The PTC_FareBreakdown
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public $PTC_FareBreakdown;
    /**
     * The TaxInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\TaxInfo
     */
    public $TaxInfo;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $RPH;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The BookingMethodReq
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BookingMethodReq;
    /**
     * The SegmentCount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SegmentCount;
    /**
     * The ItineraryPricing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ItineraryPricing
     */
    public $ItineraryPricing;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Ticketing[]
     */
    public $Ticketing;
    /**
     * Constructor method for ItineraryInfo
     * @uses ItineraryInfo::setReservationItems()
     * @uses ItineraryInfo::setPTC_FareBreakdown()
     * @uses ItineraryInfo::setTaxInfo()
     * @uses ItineraryInfo::setRPH()
     * @uses ItineraryInfo::setFlightSegment()
     * @uses ItineraryInfo::setBookingMethodReq()
     * @uses ItineraryInfo::setSegmentCount()
     * @uses ItineraryInfo::setItineraryPricing()
     * @uses ItineraryInfo::setTicketing()
     * @param \Sabre\EnhancedAirBook\Structs\ReservationItems $reservationItems
     * @param \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown $pTC_FareBreakdown
     * @param \Sabre\EnhancedAirBook\Structs\TaxInfo $taxInfo
     * @param int $rPH
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment[] $flightSegment
     * @param string $bookingMethodReq
     * @param string $segmentCount
     * @param \Sabre\EnhancedAirBook\Structs\ItineraryPricing $itineraryPricing
     * @param \Sabre\EnhancedAirBook\Structs\Ticketing[] $ticketing
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\ReservationItems $reservationItems = null, \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown $pTC_FareBreakdown = null, \Sabre\EnhancedAirBook\Structs\TaxInfo $taxInfo = null, $rPH = null, array $flightSegment = array(), $bookingMethodReq = null, $segmentCount = null, \Sabre\EnhancedAirBook\Structs\ItineraryPricing $itineraryPricing = null, array $ticketing = array())
    {
        $this
            ->setReservationItems($reservationItems)
            ->setPTC_FareBreakdown($pTC_FareBreakdown)
            ->setTaxInfo($taxInfo)
            ->setRPH($rPH)
            ->setFlightSegment($flightSegment)
            ->setBookingMethodReq($bookingMethodReq)
            ->setSegmentCount($segmentCount)
            ->setItineraryPricing($itineraryPricing)
            ->setTicketing($ticketing);
    }
    /**
     * Get ReservationItems value
     * @return \Sabre\EnhancedAirBook\Structs\ReservationItems|null
     */
    public function getReservationItems()
    {
        return $this->ReservationItems;
    }
    /**
     * Set ReservationItems value
     * @param \Sabre\EnhancedAirBook\Structs\ReservationItems $reservationItems
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setReservationItems(\Sabre\EnhancedAirBook\Structs\ReservationItems $reservationItems = null)
    {
        $this->ReservationItems = $reservationItems;
        return $this;
    }
    /**
     * Get PTC_FareBreakdown value
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown|null
     */
    public function getPTC_FareBreakdown()
    {
        return $this->PTC_FareBreakdown;
    }
    /**
     * Set PTC_FareBreakdown value
     * @param \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown $pTC_FareBreakdown
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setPTC_FareBreakdown(\Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown $pTC_FareBreakdown = null)
    {
        $this->PTC_FareBreakdown = $pTC_FareBreakdown;
        return $this;
    }
    /**
     * Get TaxInfo value
     * @return \Sabre\EnhancedAirBook\Structs\TaxInfo|null
     */
    public function getTaxInfo()
    {
        return $this->TaxInfo;
    }
    /**
     * Set TaxInfo value
     * @param \Sabre\EnhancedAirBook\Structs\TaxInfo $taxInfo
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setTaxInfo(\Sabre\EnhancedAirBook\Structs\TaxInfo $taxInfo = null)
    {
        $this->TaxInfo = $taxInfo;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment $item
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function addToFlightSegment(\Sabre\EnhancedAirBook\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get BookingMethodReq value
     * @return string|null
     */
    public function getBookingMethodReq()
    {
        return $this->BookingMethodReq;
    }
    /**
     * Set BookingMethodReq value
     * @param string $bookingMethodReq
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setBookingMethodReq($bookingMethodReq = null)
    {
        $this->BookingMethodReq = $bookingMethodReq;
        return $this;
    }
    /**
     * Get SegmentCount value
     * @return string|null
     */
    public function getSegmentCount()
    {
        return $this->SegmentCount;
    }
    /**
     * Set SegmentCount value
     * @param string $segmentCount
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setSegmentCount($segmentCount = null)
    {
        $this->SegmentCount = $segmentCount;
        return $this;
    }
    /**
     * Get ItineraryPricing value
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryPricing|null
     */
    public function getItineraryPricing()
    {
        return $this->ItineraryPricing;
    }
    /**
     * Set ItineraryPricing value
     * @param \Sabre\EnhancedAirBook\Structs\ItineraryPricing $itineraryPricing
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setItineraryPricing(\Sabre\EnhancedAirBook\Structs\ItineraryPricing $itineraryPricing = null)
    {
        $this->ItineraryPricing = $itineraryPricing;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Ticketing[] $ticketing
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function setTicketing(array $ticketing = array())
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Ticketing $item
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public function addToTicketing(\Sabre\EnhancedAirBook\Structs\Ticketing $item)
    {
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
