<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroundTransportationType Structs
 * @subpackage Structs
 */
class GroundTransportationType extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CompanyType
     */
    public $Vendor;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ServiceType
     */
    public $Service;
    /**
     * The ServiceProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ServiceProviderType
     */
    public $ServiceProvider;
    /**
     * The StartDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\LocationDetailsType
     */
    public $StartDetails;
    /**
     * The StopDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\LocationDetailsType[]
     */
    public $StopDetails;
    /**
     * The EndDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\LocationDetailsType
     */
    public $EndDetails;
    /**
     * The ExternalReservation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ExternalReservationType
     */
    public $ExternalReservation;
    /**
     * The Restrictions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\RestrictionsType
     */
    public $Restrictions;
    /**
     * The POS
     * @var \Sabre\EnhancedAirBook\Structs\POSType
     */
    public $POS;
    /**
     * The AgentLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\LoyaltyType[]
     */
    public $AgentLoyalty;
    /**
     * The Passenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PassengerType[]
     */
    public $Passenger;
    /**
     * The RateQualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\RateQualifierType[]
     */
    public $RateQualifier;
    /**
     * The Charges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ChargesType
     */
    public $Charges;
    /**
     * Constructor method for GroundTransportationType
     * @uses GroundTransportationType::setStatusCode()
     * @uses GroundTransportationType::setVendor()
     * @uses GroundTransportationType::setService()
     * @uses GroundTransportationType::setServiceProvider()
     * @uses GroundTransportationType::setStartDetails()
     * @uses GroundTransportationType::setStopDetails()
     * @uses GroundTransportationType::setEndDetails()
     * @uses GroundTransportationType::setExternalReservation()
     * @uses GroundTransportationType::setRestrictions()
     * @uses GroundTransportationType::setPOS()
     * @uses GroundTransportationType::setAgentLoyalty()
     * @uses GroundTransportationType::setPassenger()
     * @uses GroundTransportationType::setRateQualifier()
     * @uses GroundTransportationType::setCharges()
     * @param string $statusCode
     * @param \Sabre\EnhancedAirBook\Structs\CompanyType $vendor
     * @param \Sabre\EnhancedAirBook\Structs\ServiceType $service
     * @param \Sabre\EnhancedAirBook\Structs\ServiceProviderType $serviceProvider
     * @param \Sabre\EnhancedAirBook\Structs\LocationDetailsType $startDetails
     * @param \Sabre\EnhancedAirBook\Structs\LocationDetailsType[] $stopDetails
     * @param \Sabre\EnhancedAirBook\Structs\LocationDetailsType $endDetails
     * @param \Sabre\EnhancedAirBook\Structs\ExternalReservationType $externalReservation
     * @param \Sabre\EnhancedAirBook\Structs\RestrictionsType $restrictions
     * @param \Sabre\EnhancedAirBook\Structs\POSType $pOS
     * @param \Sabre\EnhancedAirBook\Structs\LoyaltyType[] $agentLoyalty
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType[] $passenger
     * @param \Sabre\EnhancedAirBook\Structs\RateQualifierType[] $rateQualifier
     * @param \Sabre\EnhancedAirBook\Structs\ChargesType $charges
     */
    public function __construct($statusCode = null, \Sabre\EnhancedAirBook\Structs\CompanyType $vendor = null, \Sabre\EnhancedAirBook\Structs\ServiceType $service = null, \Sabre\EnhancedAirBook\Structs\ServiceProviderType $serviceProvider = null, \Sabre\EnhancedAirBook\Structs\LocationDetailsType $startDetails = null, array $stopDetails = array(), \Sabre\EnhancedAirBook\Structs\LocationDetailsType $endDetails = null, \Sabre\EnhancedAirBook\Structs\ExternalReservationType $externalReservation = null, \Sabre\EnhancedAirBook\Structs\RestrictionsType $restrictions = null, \Sabre\EnhancedAirBook\Structs\POSType $pOS = null, array $agentLoyalty = array(), array $passenger = array(), array $rateQualifier = array(), \Sabre\EnhancedAirBook\Structs\ChargesType $charges = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setVendor($vendor)
            ->setService($service)
            ->setServiceProvider($serviceProvider)
            ->setStartDetails($startDetails)
            ->setStopDetails($stopDetails)
            ->setEndDetails($endDetails)
            ->setExternalReservation($externalReservation)
            ->setRestrictions($restrictions)
            ->setPOS($pOS)
            ->setAgentLoyalty($agentLoyalty)
            ->setPassenger($passenger)
            ->setRateQualifier($rateQualifier)
            ->setCharges($charges);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\EnhancedAirBook\Structs\CompanyType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\EnhancedAirBook\Structs\CompanyType $vendor
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setVendor(\Sabre\EnhancedAirBook\Structs\CompanyType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get Service value
     * @return \Sabre\EnhancedAirBook\Structs\ServiceType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Sabre\EnhancedAirBook\Structs\ServiceType $service
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setService(\Sabre\EnhancedAirBook\Structs\ServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get ServiceProvider value
     * @return \Sabre\EnhancedAirBook\Structs\ServiceProviderType|null
     */
    public function getServiceProvider()
    {
        return $this->ServiceProvider;
    }
    /**
     * Set ServiceProvider value
     * @param \Sabre\EnhancedAirBook\Structs\ServiceProviderType $serviceProvider
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setServiceProvider(\Sabre\EnhancedAirBook\Structs\ServiceProviderType $serviceProvider = null)
    {
        $this->ServiceProvider = $serviceProvider;
        return $this;
    }
    /**
     * Get StartDetails value
     * @return \Sabre\EnhancedAirBook\Structs\LocationDetailsType|null
     */
    public function getStartDetails()
    {
        return $this->StartDetails;
    }
    /**
     * Set StartDetails value
     * @param \Sabre\EnhancedAirBook\Structs\LocationDetailsType $startDetails
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setStartDetails(\Sabre\EnhancedAirBook\Structs\LocationDetailsType $startDetails = null)
    {
        $this->StartDetails = $startDetails;
        return $this;
    }
    /**
     * Get StopDetails value
     * @return \Sabre\EnhancedAirBook\Structs\LocationDetailsType[]|null
     */
    public function getStopDetails()
    {
        return $this->StopDetails;
    }
    /**
     * Set StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\LocationDetailsType[] $stopDetails
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setStopDetails(array $stopDetails = array())
    {
        $this->StopDetails = $stopDetails;
        return $this;
    }
    /**
     * Add item to StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\LocationDetailsType $item
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function addToStopDetails(\Sabre\EnhancedAirBook\Structs\LocationDetailsType $item)
    {
        $this->StopDetails[] = $item;
        return $this;
    }
    /**
     * Get EndDetails value
     * @return \Sabre\EnhancedAirBook\Structs\LocationDetailsType|null
     */
    public function getEndDetails()
    {
        return $this->EndDetails;
    }
    /**
     * Set EndDetails value
     * @param \Sabre\EnhancedAirBook\Structs\LocationDetailsType $endDetails
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setEndDetails(\Sabre\EnhancedAirBook\Structs\LocationDetailsType $endDetails = null)
    {
        $this->EndDetails = $endDetails;
        return $this;
    }
    /**
     * Get ExternalReservation value
     * @return \Sabre\EnhancedAirBook\Structs\ExternalReservationType|null
     */
    public function getExternalReservation()
    {
        return $this->ExternalReservation;
    }
    /**
     * Set ExternalReservation value
     * @param \Sabre\EnhancedAirBook\Structs\ExternalReservationType $externalReservation
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setExternalReservation(\Sabre\EnhancedAirBook\Structs\ExternalReservationType $externalReservation = null)
    {
        $this->ExternalReservation = $externalReservation;
        return $this;
    }
    /**
     * Get Restrictions value
     * @return \Sabre\EnhancedAirBook\Structs\RestrictionsType|null
     */
    public function getRestrictions()
    {
        return $this->Restrictions;
    }
    /**
     * Set Restrictions value
     * @param \Sabre\EnhancedAirBook\Structs\RestrictionsType $restrictions
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setRestrictions(\Sabre\EnhancedAirBook\Structs\RestrictionsType $restrictions = null)
    {
        $this->Restrictions = $restrictions;
        return $this;
    }
    /**
     * Get POS value
     * @return \Sabre\EnhancedAirBook\Structs\POSType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\EnhancedAirBook\Structs\POSType $pOS
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setPOS(\Sabre\EnhancedAirBook\Structs\POSType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get AgentLoyalty value
     * @return \Sabre\EnhancedAirBook\Structs\LoyaltyType[]|null
     */
    public function getAgentLoyalty()
    {
        return $this->AgentLoyalty;
    }
    /**
     * Set AgentLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\LoyaltyType[] $agentLoyalty
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setAgentLoyalty(array $agentLoyalty = array())
    {
        $this->AgentLoyalty = $agentLoyalty;
        return $this;
    }
    /**
     * Add item to AgentLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\LoyaltyType $item
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function addToAgentLoyalty(\Sabre\EnhancedAirBook\Structs\LoyaltyType $item)
    {
        $this->AgentLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Passenger value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType[]|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType[] $passenger
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setPassenger(array $passenger = array())
    {
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Add item to Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType $item
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function addToPassenger(\Sabre\EnhancedAirBook\Structs\PassengerType $item)
    {
        $this->Passenger[] = $item;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \Sabre\EnhancedAirBook\Structs\RateQualifierType[]|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\RateQualifierType[] $rateQualifier
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setRateQualifier(array $rateQualifier = array())
    {
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Add item to RateQualifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\RateQualifierType $item
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function addToRateQualifier(\Sabre\EnhancedAirBook\Structs\RateQualifierType $item)
    {
        $this->RateQualifier[] = $item;
        return $this;
    }
    /**
     * Get Charges value
     * @return \Sabre\EnhancedAirBook\Structs\ChargesType|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \Sabre\EnhancedAirBook\Structs\ChargesType $charges
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public function setCharges(\Sabre\EnhancedAirBook\Structs\ChargesType $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\GroundTransportationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
