<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fare Structs
 * @subpackage Structs
 */
class Fare extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Amount;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The PassengerReferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PassengerReferences
     */
    public $PassengerReferences;
    /**
     * The SegmentReferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SegmentReferences
     */
    public $SegmentReferences;
    /**
     * The ClassOfService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClassOfService;
    /**
     * The FareDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareDescription
     */
    public $FareDescription;
    /**
     * The FarePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PriceType
     */
    public $FarePrice;
    /**
     * Constructor method for Fare
     * @uses Fare::setAmount()
     * @uses Fare::setType()
     * @uses Fare::setPassengerReferences()
     * @uses Fare::setSegmentReferences()
     * @uses Fare::setClassOfService()
     * @uses Fare::setFareDescription()
     * @uses Fare::setFarePrice()
     * @param string $amount
     * @param string $type
     * @param \Sabre\EnhancedAirBook\Structs\PassengerReferences $passengerReferences
     * @param \Sabre\EnhancedAirBook\Structs\SegmentReferences $segmentReferences
     * @param string $classOfService
     * @param \Sabre\EnhancedAirBook\Structs\FareDescription $fareDescription
     * @param \Sabre\EnhancedAirBook\Structs\PriceType $farePrice
     */
    public function __construct($amount = null, $type = null, \Sabre\EnhancedAirBook\Structs\PassengerReferences $passengerReferences = null, \Sabre\EnhancedAirBook\Structs\SegmentReferences $segmentReferences = null, $classOfService = null, \Sabre\EnhancedAirBook\Structs\FareDescription $fareDescription = null, \Sabre\EnhancedAirBook\Structs\PriceType $farePrice = null)
    {
        $this
            ->setAmount($amount)
            ->setType($type)
            ->setPassengerReferences($passengerReferences)
            ->setSegmentReferences($segmentReferences)
            ->setClassOfService($classOfService)
            ->setFareDescription($fareDescription)
            ->setFarePrice($farePrice);
    }
    /**
     * Get Amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\EnhancedAirBook\Structs\Fare
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\EnhancedAirBook\Structs\Fare
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PassengerReferences value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerReferences|null
     */
    public function getPassengerReferences()
    {
        return $this->PassengerReferences;
    }
    /**
     * Set PassengerReferences value
     * @param \Sabre\EnhancedAirBook\Structs\PassengerReferences $passengerReferences
     * @return \Sabre\EnhancedAirBook\Structs\Fare
     */
    public function setPassengerReferences(\Sabre\EnhancedAirBook\Structs\PassengerReferences $passengerReferences = null)
    {
        $this->PassengerReferences = $passengerReferences;
        return $this;
    }
    /**
     * Get SegmentReferences value
     * @return \Sabre\EnhancedAirBook\Structs\SegmentReferences|null
     */
    public function getSegmentReferences()
    {
        return $this->SegmentReferences;
    }
    /**
     * Set SegmentReferences value
     * @param \Sabre\EnhancedAirBook\Structs\SegmentReferences $segmentReferences
     * @return \Sabre\EnhancedAirBook\Structs\Fare
     */
    public function setSegmentReferences(\Sabre\EnhancedAirBook\Structs\SegmentReferences $segmentReferences = null)
    {
        $this->SegmentReferences = $segmentReferences;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \Sabre\EnhancedAirBook\Structs\Fare
     */
    public function setClassOfService($classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get FareDescription value
     * @return \Sabre\EnhancedAirBook\Structs\FareDescription|null
     */
    public function getFareDescription()
    {
        return $this->FareDescription;
    }
    /**
     * Set FareDescription value
     * @param \Sabre\EnhancedAirBook\Structs\FareDescription $fareDescription
     * @return \Sabre\EnhancedAirBook\Structs\Fare
     */
    public function setFareDescription(\Sabre\EnhancedAirBook\Structs\FareDescription $fareDescription = null)
    {
        $this->FareDescription = $fareDescription;
        return $this;
    }
    /**
     * Get FarePrice value
     * @return \Sabre\EnhancedAirBook\Structs\PriceType|null
     */
    public function getFarePrice()
    {
        return $this->FarePrice;
    }
    /**
     * Set FarePrice value
     * @param \Sabre\EnhancedAirBook\Structs\PriceType $farePrice
     * @return \Sabre\EnhancedAirBook\Structs\Fare
     */
    public function setFarePrice(\Sabre\EnhancedAirBook\Structs\PriceType $farePrice = null)
    {
        $this->FarePrice = $farePrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Fare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
