<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Exchange Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Exchange" holds indicator to denote whether or not the the accounting line relates to an exchange transaction Example: Exchange Ind="false"
 * @subpackage Structs
 */
class Exchange extends AbstractStructBase
{
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Ind;
    /**
     * Constructor method for Exchange
     * @uses Exchange::setInd()
     * @param bool $ind
     */
    public function __construct($ind = null)
    {
        $this
            ->setInd($ind);
    }
    /**
     * Get Ind value
     * @return bool|null
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\EnhancedAirBook\Structs\Exchange
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Exchange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
