<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnhancedAirBookRQ Structs
 * @subpackage Structs
 */
class EnhancedAirBookRQ extends STL_Request_Payload
{
    /**
     * The AirTaxRQ
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AirTaxRQ
     */
    public $AirTaxRQ;
    /**
     * The OTA_AirBookRQ
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\OTA_AirBookRQ
     */
    public $OTA_AirBookRQ;
    /**
     * The OTA_AirPriceRQ
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\OTA_AirPriceRQ
     */
    public $OTA_AirPriceRQ;
    /**
     * The PostProcessing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PostProcessing
     */
    public $PostProcessing;
    /**
     * The PreProcessing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PreProcessing
     */
    public $PreProcessing;
    /**
     * The HaltOnError
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $HaltOnError;
    /**
     * The IgnoreOnError
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $IgnoreOnError;
    /**
     * Constructor method for EnhancedAirBookRQ
     * @uses EnhancedAirBookRQ::setAirTaxRQ()
     * @uses EnhancedAirBookRQ::setOTA_AirBookRQ()
     * @uses EnhancedAirBookRQ::setOTA_AirPriceRQ()
     * @uses EnhancedAirBookRQ::setPostProcessing()
     * @uses EnhancedAirBookRQ::setPreProcessing()
     * @uses EnhancedAirBookRQ::setHaltOnError()
     * @uses EnhancedAirBookRQ::setIgnoreOnError()
     * @param \Sabre\EnhancedAirBook\Structs\AirTaxRQ $airTaxRQ
     * @param \Sabre\EnhancedAirBook\Structs\OTA_AirBookRQ $oTA_AirBookRQ
     * @param \Sabre\EnhancedAirBook\Structs\OTA_AirPriceRQ $oTA_AirPriceRQ
     * @param \Sabre\EnhancedAirBook\Structs\PostProcessing $postProcessing
     * @param \Sabre\EnhancedAirBook\Structs\PreProcessing $preProcessing
     * @param bool $haltOnError
     * @param bool $ignoreOnError
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\AirTaxRQ $airTaxRQ = null, \Sabre\EnhancedAirBook\Structs\OTA_AirBookRQ $oTA_AirBookRQ = null, \Sabre\EnhancedAirBook\Structs\OTA_AirPriceRQ $oTA_AirPriceRQ = null, \Sabre\EnhancedAirBook\Structs\PostProcessing $postProcessing = null, \Sabre\EnhancedAirBook\Structs\PreProcessing $preProcessing = null, $haltOnError = null, $ignoreOnError = null)
    {
        $this
            ->setAirTaxRQ($airTaxRQ)
            ->setOTA_AirBookRQ($oTA_AirBookRQ)
            ->setOTA_AirPriceRQ($oTA_AirPriceRQ)
            ->setPostProcessing($postProcessing)
            ->setPreProcessing($preProcessing)
            ->setHaltOnError($haltOnError)
            ->setIgnoreOnError($ignoreOnError);
    }
    /**
     * Get AirTaxRQ value
     * @return \Sabre\EnhancedAirBook\Structs\AirTaxRQ|null
     */
    public function getAirTaxRQ()
    {
        return $this->AirTaxRQ;
    }
    /**
     * Set AirTaxRQ value
     * @param \Sabre\EnhancedAirBook\Structs\AirTaxRQ $airTaxRQ
     * @return \Sabre\EnhancedAirBook\Structs\EnhancedAirBookRQ
     */
    public function setAirTaxRQ(\Sabre\EnhancedAirBook\Structs\AirTaxRQ $airTaxRQ = null)
    {
        $this->AirTaxRQ = $airTaxRQ;
        return $this;
    }
    /**
     * Get OTA_AirBookRQ value
     * @return \Sabre\EnhancedAirBook\Structs\OTA_AirBookRQ|null
     */
    public function getOTA_AirBookRQ()
    {
        return $this->OTA_AirBookRQ;
    }
    /**
     * Set OTA_AirBookRQ value
     * @param \Sabre\EnhancedAirBook\Structs\OTA_AirBookRQ $oTA_AirBookRQ
     * @return \Sabre\EnhancedAirBook\Structs\EnhancedAirBookRQ
     */
    public function setOTA_AirBookRQ(\Sabre\EnhancedAirBook\Structs\OTA_AirBookRQ $oTA_AirBookRQ = null)
    {
        $this->OTA_AirBookRQ = $oTA_AirBookRQ;
        return $this;
    }
    /**
     * Get OTA_AirPriceRQ value
     * @return \Sabre\EnhancedAirBook\Structs\OTA_AirPriceRQ|null
     */
    public function getOTA_AirPriceRQ()
    {
        return $this->OTA_AirPriceRQ;
    }
    /**
     * Set OTA_AirPriceRQ value
     * @param \Sabre\EnhancedAirBook\Structs\OTA_AirPriceRQ $oTA_AirPriceRQ
     * @return \Sabre\EnhancedAirBook\Structs\EnhancedAirBookRQ
     */
    public function setOTA_AirPriceRQ(\Sabre\EnhancedAirBook\Structs\OTA_AirPriceRQ $oTA_AirPriceRQ = null)
    {
        $this->OTA_AirPriceRQ = $oTA_AirPriceRQ;
        return $this;
    }
    /**
     * Get PostProcessing value
     * @return \Sabre\EnhancedAirBook\Structs\PostProcessing|null
     */
    public function getPostProcessing()
    {
        return $this->PostProcessing;
    }
    /**
     * Set PostProcessing value
     * @param \Sabre\EnhancedAirBook\Structs\PostProcessing $postProcessing
     * @return \Sabre\EnhancedAirBook\Structs\EnhancedAirBookRQ
     */
    public function setPostProcessing(\Sabre\EnhancedAirBook\Structs\PostProcessing $postProcessing = null)
    {
        $this->PostProcessing = $postProcessing;
        return $this;
    }
    /**
     * Get PreProcessing value
     * @return \Sabre\EnhancedAirBook\Structs\PreProcessing|null
     */
    public function getPreProcessing()
    {
        return $this->PreProcessing;
    }
    /**
     * Set PreProcessing value
     * @param \Sabre\EnhancedAirBook\Structs\PreProcessing $preProcessing
     * @return \Sabre\EnhancedAirBook\Structs\EnhancedAirBookRQ
     */
    public function setPreProcessing(\Sabre\EnhancedAirBook\Structs\PreProcessing $preProcessing = null)
    {
        $this->PreProcessing = $preProcessing;
        return $this;
    }
    /**
     * Get HaltOnError value
     * @return bool|null
     */
    public function getHaltOnError()
    {
        return $this->HaltOnError;
    }
    /**
     * Set HaltOnError value
     * @param bool $haltOnError
     * @return \Sabre\EnhancedAirBook\Structs\EnhancedAirBookRQ
     */
    public function setHaltOnError($haltOnError = null)
    {
        $this->HaltOnError = $haltOnError;
        return $this;
    }
    /**
     * Get IgnoreOnError value
     * @return bool|null
     */
    public function getIgnoreOnError()
    {
        return $this->IgnoreOnError;
    }
    /**
     * Set IgnoreOnError value
     * @param bool $ignoreOnError
     * @return \Sabre\EnhancedAirBook\Structs\EnhancedAirBookRQ
     */
    public function setIgnoreOnError($ignoreOnError = null)
    {
        $this->IgnoreOnError = $ignoreOnError;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\EnhancedAirBookRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
