<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: Holds the Document Number information Example: Number="1234567890"
 * @subpackage Structs
 */
class DocumentInfo extends AbstractStructBase
{
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Document
     */
    public $Document;
    /**
     * Constructor method for DocumentInfo
     * @uses DocumentInfo::setDocument()
     * @param \Sabre\EnhancedAirBook\Structs\Document $document
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Document $document = null)
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get Document value
     * @return \Sabre\EnhancedAirBook\Structs\Document|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \Sabre\EnhancedAirBook\Structs\Document $document
     * @return \Sabre\EnhancedAirBook\Structs\DocumentInfo
     */
    public function setDocument(\Sabre\EnhancedAirBook\Structs\Document $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\DocumentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
