<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coach Structs
 * @subpackage Structs
 */
class Coach extends AbstractStructBase
{
    /**
     * The CoachNumber
     * @var string
     */
    public $CoachNumber;
    /**
     * The PlacementNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\EnhancedAirBook\Structs\PlacementNumber[]
     */
    public $PlacementNumber;
    /**
     * The CompartmentNumber
     * @var string
     */
    public $CompartmentNumber;
    /**
     * Constructor method for Coach
     * @uses Coach::setCoachNumber()
     * @uses Coach::setPlacementNumber()
     * @uses Coach::setCompartmentNumber()
     * @param string $coachNumber
     * @param \Sabre\EnhancedAirBook\Structs\PlacementNumber[] $placementNumber
     * @param string $compartmentNumber
     */
    public function __construct($coachNumber = null, array $placementNumber = array(), $compartmentNumber = null)
    {
        $this
            ->setCoachNumber($coachNumber)
            ->setPlacementNumber($placementNumber)
            ->setCompartmentNumber($compartmentNumber);
    }
    /**
     * Get CoachNumber value
     * @return string|null
     */
    public function getCoachNumber()
    {
        return $this->CoachNumber;
    }
    /**
     * Set CoachNumber value
     * @param string $coachNumber
     * @return \Sabre\EnhancedAirBook\Structs\Coach
     */
    public function setCoachNumber($coachNumber = null)
    {
        $this->CoachNumber = $coachNumber;
        return $this;
    }
    /**
     * Get PlacementNumber value
     * @return \Sabre\EnhancedAirBook\Structs\PlacementNumber[]|null
     */
    public function getPlacementNumber()
    {
        return $this->PlacementNumber;
    }
    /**
     * Set PlacementNumber value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PlacementNumber[] $placementNumber
     * @return \Sabre\EnhancedAirBook\Structs\Coach
     */
    public function setPlacementNumber(array $placementNumber = array())
    {
        $this->PlacementNumber = $placementNumber;
        return $this;
    }
    /**
     * Add item to PlacementNumber value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PlacementNumber $item
     * @return \Sabre\EnhancedAirBook\Structs\Coach
     */
    public function addToPlacementNumber(\Sabre\EnhancedAirBook\Structs\PlacementNumber $item)
    {
        $this->PlacementNumber[] = $item;
        return $this;
    }
    /**
     * Get CompartmentNumber value
     * @return string|null
     */
    public function getCompartmentNumber()
    {
        return $this->CompartmentNumber;
    }
    /**
     * Set CompartmentNumber value
     * @param string $compartmentNumber
     * @return \Sabre\EnhancedAirBook\Structs\Coach
     */
    public function setCompartmentNumber($compartmentNumber = null)
    {
        $this->CompartmentNumber = $compartmentNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Coach
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
