<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeType Structs
 * @subpackage Structs
 */
class ChargeType extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Calculation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CalculationType[]
     */
    public $Calculation;
    /**
     * The BillingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BillingType;
    /**
     * The currencyCode
     * @var string
     */
    public $currencyCode;
    /**
     * Constructor method for ChargeType
     * @uses ChargeType::setDescription()
     * @uses ChargeType::setNotes()
     * @uses ChargeType::setName()
     * @uses ChargeType::setCalculation()
     * @uses ChargeType::setBillingType()
     * @uses ChargeType::setCurrencyCode()
     * @param string $description
     * @param string $notes
     * @param string $name
     * @param \Sabre\EnhancedAirBook\Structs\CalculationType[] $calculation
     * @param string $billingType
     * @param string $currencyCode
     */
    public function __construct($description = null, $notes = null, $name = null, array $calculation = array(), $billingType = null, $currencyCode = null)
    {
        $this
            ->setDescription($description)
            ->setNotes($notes)
            ->setName($name)
            ->setCalculation($calculation)
            ->setBillingType($billingType)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\EnhancedAirBook\Structs\ChargeType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \Sabre\EnhancedAirBook\Structs\ChargeType
     */
    public function setNotes($notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\EnhancedAirBook\Structs\ChargeType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Calculation value
     * @return \Sabre\EnhancedAirBook\Structs\CalculationType[]|null
     */
    public function getCalculation()
    {
        return $this->Calculation;
    }
    /**
     * Set Calculation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CalculationType[] $calculation
     * @return \Sabre\EnhancedAirBook\Structs\ChargeType
     */
    public function setCalculation(array $calculation = array())
    {
        $this->Calculation = $calculation;
        return $this;
    }
    /**
     * Add item to Calculation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CalculationType $item
     * @return \Sabre\EnhancedAirBook\Structs\ChargeType
     */
    public function addToCalculation(\Sabre\EnhancedAirBook\Structs\CalculationType $item)
    {
        $this->Calculation[] = $item;
        return $this;
    }
    /**
     * Get BillingType value
     * @return string|null
     */
    public function getBillingType()
    {
        return $this->BillingType;
    }
    /**
     * Set BillingType value
     * @param string $billingType
     * @return \Sabre\EnhancedAirBook\Structs\ChargeType
     */
    public function setBillingType($billingType = null)
    {
        $this->BillingType = $billingType;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \Sabre\EnhancedAirBook\Structs\ChargeType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\ChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
