<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicPropertyInfo Structs
 * @subpackage Structs
 */
class BasicPropertyInfo extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Address
     */
    public $Address;
    /**
     * The CancelPenalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CancelPenalty[]
     */
    public $CancelPenalty;
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: "ConfirmationNumber" is used to return the booking confirmation number associated with the particular hotel reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ConfirmationNumber;
    /**
     * The DirectConnect
     * Meta informations extracted from the WSDL
     * - documentation: "DirectConnect" is used to return miscellaneous direct connect-related information
     * - minOccurs: 0
     * @var string
     */
    public $DirectConnect;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The ChainCode
     * Meta informations extracted from the WSDL
     * - documentation: "ChainCode" is used to return the hotel chain code associated with the particular hotel reservation.
     * - use: optional
     * @var string
     */
    public $ChainCode;
    /**
     * The HotelCityCode
     * Meta informations extracted from the WSDL
     * - documentation: "HotelCityCode" is used to return the hotel location code associated with the particular hotel reservation.
     * - use: optional
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelCode
     * Meta informations extracted from the WSDL
     * - documentation: "HotelCode" is used to return the hotel property code associated with the particular hotel reservation.
     * - use: optional
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - documentation: "HotelName" is used to return the hotel name associated with the particular hotel reservation.
     * - use: optional
     * @var string
     */
    public $HotelName;
    /**
     * The ServiceCityName
     * Meta informations extracted from the WSDL
     * - documentation: "ServiceCityName" is used to return the hotel location code associated with the particular hotel reservation.
     * - use: optional
     * @var string
     */
    public $ServiceCityName;
    /**
     * Constructor method for BasicPropertyInfo
     * @uses BasicPropertyInfo::setAddress()
     * @uses BasicPropertyInfo::setCancelPenalty()
     * @uses BasicPropertyInfo::setConfirmationNumber()
     * @uses BasicPropertyInfo::setDirectConnect()
     * @uses BasicPropertyInfo::setContactNumbers()
     * @uses BasicPropertyInfo::setChainCode()
     * @uses BasicPropertyInfo::setHotelCityCode()
     * @uses BasicPropertyInfo::setHotelCode()
     * @uses BasicPropertyInfo::setHotelName()
     * @uses BasicPropertyInfo::setServiceCityName()
     * @param \Sabre\EnhancedAirBook\Structs\Address $address
     * @param \Sabre\EnhancedAirBook\Structs\CancelPenalty[] $cancelPenalty
     * @param string[] $confirmationNumber
     * @param string $directConnect
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @param string $chainCode
     * @param string $hotelCityCode
     * @param string $hotelCode
     * @param string $hotelName
     * @param string $serviceCityName
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Address $address = null, array $cancelPenalty = array(), array $confirmationNumber = array(), $directConnect = null, \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null, $chainCode = null, $hotelCityCode = null, $hotelCode = null, $hotelName = null, $serviceCityName = null)
    {
        $this
            ->setAddress($address)
            ->setCancelPenalty($cancelPenalty)
            ->setConfirmationNumber($confirmationNumber)
            ->setDirectConnect($directConnect)
            ->setContactNumbers($contactNumbers)
            ->setChainCode($chainCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName)
            ->setServiceCityName($serviceCityName);
    }
    /**
     * Get Address value
     * @return \Sabre\EnhancedAirBook\Structs\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\EnhancedAirBook\Structs\Address $address
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setAddress(\Sabre\EnhancedAirBook\Structs\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get CancelPenalty value
     * @return \Sabre\EnhancedAirBook\Structs\CancelPenalty[]|null
     */
    public function getCancelPenalty()
    {
        return $this->CancelPenalty;
    }
    /**
     * Set CancelPenalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CancelPenalty[] $cancelPenalty
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setCancelPenalty(array $cancelPenalty = array())
    {
        $this->CancelPenalty = $cancelPenalty;
        return $this;
    }
    /**
     * Add item to CancelPenalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CancelPenalty $item
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function addToCancelPenalty(\Sabre\EnhancedAirBook\Structs\CancelPenalty $item)
    {
        $this->CancelPenalty[] = $item;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string[]|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param string[] $confirmationNumber
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setConfirmationNumber(array $confirmationNumber = array())
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Add item to ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function addToConfirmationNumber($item)
    {
        $this->ConfirmationNumber[] = $item;
        return $this;
    }
    /**
     * Get DirectConnect value
     * @return string|null
     */
    public function getDirectConnect()
    {
        return $this->DirectConnect;
    }
    /**
     * Set DirectConnect value
     * @param string $directConnect
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setDirectConnect($directConnect = null)
    {
        $this->DirectConnect = $directConnect;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setContactNumbers(\Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setChainCode($chainCode = null)
    {
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setHotelCode($hotelCode = null)
    {
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setHotelName($hotelName = null)
    {
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get ServiceCityName value
     * @return string|null
     */
    public function getServiceCityName()
    {
        return $this->ServiceCityName;
    }
    /**
     * Set ServiceCityName value
     * @param string $serviceCityName
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public function setServiceCityName($serviceCityName = null)
    {
        $this->ServiceCityName = $serviceCityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\BasicPropertyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
