<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalInformation Structs
 * @subpackage Structs
 */
class AdditionalInformation extends AbstractStructBase
{
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ConfirmationNumber[]
     */
    public $ConfirmationNumber;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Address
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The CancelPenaltyPolicyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CancelPenaltyPolicyCode;
    /**
     * The CustLoyaltyMembershipID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CustLoyaltyMembershipID;
    /**
     * The IDNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $IDNumber;
    /**
     * The CorporateIDNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CorporateIDNumber;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Commission
     */
    public $Commission;
    /**
     * The WrittenConfirmation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $WrittenConfirmation;
    /**
     * Constructor method for AdditionalInformation
     * @uses AdditionalInformation::setConfirmationNumber()
     * @uses AdditionalInformation::setAddress()
     * @uses AdditionalInformation::setContactNumbers()
     * @uses AdditionalInformation::setCancelPenaltyPolicyCode()
     * @uses AdditionalInformation::setCustLoyaltyMembershipID()
     * @uses AdditionalInformation::setIDNumber()
     * @uses AdditionalInformation::setCorporateIDNumber()
     * @uses AdditionalInformation::setText()
     * @uses AdditionalInformation::setCommission()
     * @uses AdditionalInformation::setWrittenConfirmation()
     * @param \Sabre\EnhancedAirBook\Structs\ConfirmationNumber[] $confirmationNumber
     * @param \Sabre\EnhancedAirBook\Structs\Address $address
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @param string[] $cancelPenaltyPolicyCode
     * @param string[] $custLoyaltyMembershipID
     * @param string[] $iDNumber
     * @param string[] $corporateIDNumber
     * @param string[] $text
     * @param \Sabre\EnhancedAirBook\Structs\Commission $commission
     * @param bool $writtenConfirmation
     */
    public function __construct(array $confirmationNumber = array(), \Sabre\EnhancedAirBook\Structs\Address $address = null, \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null, array $cancelPenaltyPolicyCode = array(), array $custLoyaltyMembershipID = array(), array $iDNumber = array(), array $corporateIDNumber = array(), array $text = array(), \Sabre\EnhancedAirBook\Structs\Commission $commission = null, $writtenConfirmation = null)
    {
        $this
            ->setConfirmationNumber($confirmationNumber)
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setCancelPenaltyPolicyCode($cancelPenaltyPolicyCode)
            ->setCustLoyaltyMembershipID($custLoyaltyMembershipID)
            ->setIDNumber($iDNumber)
            ->setCorporateIDNumber($corporateIDNumber)
            ->setText($text)
            ->setCommission($commission)
            ->setWrittenConfirmation($writtenConfirmation);
    }
    /**
     * Get ConfirmationNumber value
     * @return \Sabre\EnhancedAirBook\Structs\ConfirmationNumber[]|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ConfirmationNumber[] $confirmationNumber
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setConfirmationNumber(array $confirmationNumber = array())
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Add item to ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ConfirmationNumber $item
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function addToConfirmationNumber(\Sabre\EnhancedAirBook\Structs\ConfirmationNumber $item)
    {
        $this->ConfirmationNumber[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\EnhancedAirBook\Structs\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\EnhancedAirBook\Structs\Address $address
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setAddress(\Sabre\EnhancedAirBook\Structs\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setContactNumbers(\Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get CancelPenaltyPolicyCode value
     * @return string[]|null
     */
    public function getCancelPenaltyPolicyCode()
    {
        return $this->CancelPenaltyPolicyCode;
    }
    /**
     * Set CancelPenaltyPolicyCode value
     * @throws \InvalidArgumentException
     * @param string[] $cancelPenaltyPolicyCode
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setCancelPenaltyPolicyCode(array $cancelPenaltyPolicyCode = array())
    {
        $this->CancelPenaltyPolicyCode = $cancelPenaltyPolicyCode;
        return $this;
    }
    /**
     * Add item to CancelPenaltyPolicyCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function addToCancelPenaltyPolicyCode($item)
    {
        $this->CancelPenaltyPolicyCode[] = $item;
        return $this;
    }
    /**
     * Get CustLoyaltyMembershipID value
     * @return string[]|null
     */
    public function getCustLoyaltyMembershipID()
    {
        return $this->CustLoyaltyMembershipID;
    }
    /**
     * Set CustLoyaltyMembershipID value
     * @throws \InvalidArgumentException
     * @param string[] $custLoyaltyMembershipID
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setCustLoyaltyMembershipID(array $custLoyaltyMembershipID = array())
    {
        $this->CustLoyaltyMembershipID = $custLoyaltyMembershipID;
        return $this;
    }
    /**
     * Add item to CustLoyaltyMembershipID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function addToCustLoyaltyMembershipID($item)
    {
        $this->CustLoyaltyMembershipID[] = $item;
        return $this;
    }
    /**
     * Get IDNumber value
     * @return string[]|null
     */
    public function getIDNumber()
    {
        return $this->IDNumber;
    }
    /**
     * Set IDNumber value
     * @throws \InvalidArgumentException
     * @param string[] $iDNumber
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setIDNumber(array $iDNumber = array())
    {
        $this->IDNumber = $iDNumber;
        return $this;
    }
    /**
     * Add item to IDNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function addToIDNumber($item)
    {
        $this->IDNumber[] = $item;
        return $this;
    }
    /**
     * Get CorporateIDNumber value
     * @return string[]|null
     */
    public function getCorporateIDNumber()
    {
        return $this->CorporateIDNumber;
    }
    /**
     * Set CorporateIDNumber value
     * @throws \InvalidArgumentException
     * @param string[] $corporateIDNumber
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setCorporateIDNumber(array $corporateIDNumber = array())
    {
        $this->CorporateIDNumber = $corporateIDNumber;
        return $this;
    }
    /**
     * Add item to CorporateIDNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function addToCorporateIDNumber($item)
    {
        $this->CorporateIDNumber[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \Sabre\EnhancedAirBook\Structs\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \Sabre\EnhancedAirBook\Structs\Commission $commission
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setCommission(\Sabre\EnhancedAirBook\Structs\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get WrittenConfirmation value
     * @return bool|null
     */
    public function getWrittenConfirmation()
    {
        return $this->WrittenConfirmation;
    }
    /**
     * Set WrittenConfirmation value
     * @param bool $writtenConfirmation
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public function setWrittenConfirmation($writtenConfirmation = null)
    {
        $this->WrittenConfirmation = $writtenConfirmation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
