<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidityDates Structs
 * @subpackage Structs
 */
class ValidityDates extends AbstractStructBase
{
    /**
     * The NotValidAfter
     * Meta informations extracted from the WSDL
     * - documentation: "NotValidAfter" is used to return the ending validity date associated with the particular flight segment. "NotValidAfter" follows this format: MM:DD | A simple date type. Allows specifying a date without a year. Accepted formats:
     * "yyyy-mm-dd" or "mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $NotValidAfter;
    /**
     * The NotValidBefore
     * Meta informations extracted from the WSDL
     * - documentation: "NotValidBefore" is used to return the beginning validity date associated with the particular flight segment. "NotValidBefore" follows this format: MM:DD | A simple date type. Allows specifying a date without a year. Accepted
     * formats: "yyyy-mm-dd" or "mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $NotValidBefore;
    /**
     * The Segment
     * @var \Sabre\EnhancedAirBook\Structs\Segment
     */
    public $Segment;
    /**
     * Constructor method for ValidityDates
     * @uses ValidityDates::setNotValidAfter()
     * @uses ValidityDates::setNotValidBefore()
     * @uses ValidityDates::setSegment()
     * @param string $notValidAfter
     * @param string $notValidBefore
     * @param \Sabre\EnhancedAirBook\Structs\Segment $segment
     */
    public function __construct($notValidAfter = null, $notValidBefore = null, \Sabre\EnhancedAirBook\Structs\Segment $segment = null)
    {
        $this
            ->setNotValidAfter($notValidAfter)
            ->setNotValidBefore($notValidBefore)
            ->setSegment($segment);
    }
    /**
     * Get NotValidAfter value
     * @return string|null
     */
    public function getNotValidAfter()
    {
        return $this->NotValidAfter;
    }
    /**
     * Set NotValidAfter value
     * @param string $notValidAfter
     * @return \Sabre\EnhancedAirBook\Structs\ValidityDates
     */
    public function setNotValidAfter($notValidAfter = null)
    {
        $this->NotValidAfter = $notValidAfter;
        return $this;
    }
    /**
     * Get NotValidBefore value
     * @return string|null
     */
    public function getNotValidBefore()
    {
        return $this->NotValidBefore;
    }
    /**
     * Set NotValidBefore value
     * @param string $notValidBefore
     * @return \Sabre\EnhancedAirBook\Structs\ValidityDates
     */
    public function setNotValidBefore($notValidBefore = null)
    {
        $this->NotValidBefore = $notValidBefore;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\EnhancedAirBook\Structs\Segment|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \Sabre\EnhancedAirBook\Structs\Segment $segment
     * @return \Sabre\EnhancedAirBook\Structs\ValidityDates
     */
    public function setSegment(\Sabre\EnhancedAirBook\Structs\Segment $segment = null)
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\ValidityDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
