<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailwayStationInfo Structs
 * @subpackage Structs
 */
class RailwayStationInfo extends RailwayStationInfoType
{
    /**
     * The StationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\StationName
     */
    public $StationName;
    /**
     * The LocalStationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\LocalStationName
     */
    public $LocalStationName;
    /**
     * The LocationCodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\LocationCodes
     */
    public $LocationCodes;
    /**
     * The Amenities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Amenities
     */
    public $Amenities;
    /**
     * The borderPoint
     * @var string
     */
    public $borderPoint;
    /**
     * Constructor method for RailwayStationInfo
     * @uses RailwayStationInfo::setStationName()
     * @uses RailwayStationInfo::setLocalStationName()
     * @uses RailwayStationInfo::setLocationCodes()
     * @uses RailwayStationInfo::setAmenities()
     * @uses RailwayStationInfo::setBorderPoint()
     * @param \Sabre\EnhancedAirBook\Structs\StationName $stationName
     * @param \Sabre\EnhancedAirBook\Structs\LocalStationName $localStationName
     * @param \Sabre\EnhancedAirBook\Structs\LocationCodes $locationCodes
     * @param \Sabre\EnhancedAirBook\Structs\Amenities $amenities
     * @param string $borderPoint
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\StationName $stationName = null, \Sabre\EnhancedAirBook\Structs\LocalStationName $localStationName = null, \Sabre\EnhancedAirBook\Structs\LocationCodes $locationCodes = null, \Sabre\EnhancedAirBook\Structs\Amenities $amenities = null, $borderPoint = null)
    {
        $this
            ->setStationName($stationName)
            ->setLocalStationName($localStationName)
            ->setLocationCodes($locationCodes)
            ->setAmenities($amenities)
            ->setBorderPoint($borderPoint);
    }
    /**
     * Get StationName value
     * @return \Sabre\EnhancedAirBook\Structs\StationName|null
     */
    public function getStationName()
    {
        return $this->StationName;
    }
    /**
     * Set StationName value
     * @param \Sabre\EnhancedAirBook\Structs\StationName $stationName
     * @return \Sabre\EnhancedAirBook\Structs\RailwayStationInfo
     */
    public function setStationName(\Sabre\EnhancedAirBook\Structs\StationName $stationName = null)
    {
        $this->StationName = $stationName;
        return $this;
    }
    /**
     * Get LocalStationName value
     * @return \Sabre\EnhancedAirBook\Structs\LocalStationName|null
     */
    public function getLocalStationName()
    {
        return $this->LocalStationName;
    }
    /**
     * Set LocalStationName value
     * @param \Sabre\EnhancedAirBook\Structs\LocalStationName $localStationName
     * @return \Sabre\EnhancedAirBook\Structs\RailwayStationInfo
     */
    public function setLocalStationName(\Sabre\EnhancedAirBook\Structs\LocalStationName $localStationName = null)
    {
        $this->LocalStationName = $localStationName;
        return $this;
    }
    /**
     * Get LocationCodes value
     * @return \Sabre\EnhancedAirBook\Structs\LocationCodes|null
     */
    public function getLocationCodes()
    {
        return $this->LocationCodes;
    }
    /**
     * Set LocationCodes value
     * @param \Sabre\EnhancedAirBook\Structs\LocationCodes $locationCodes
     * @return \Sabre\EnhancedAirBook\Structs\RailwayStationInfo
     */
    public function setLocationCodes(\Sabre\EnhancedAirBook\Structs\LocationCodes $locationCodes = null)
    {
        $this->LocationCodes = $locationCodes;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \Sabre\EnhancedAirBook\Structs\Amenities|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \Sabre\EnhancedAirBook\Structs\Amenities $amenities
     * @return \Sabre\EnhancedAirBook\Structs\RailwayStationInfo
     */
    public function setAmenities(\Sabre\EnhancedAirBook\Structs\Amenities $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get borderPoint value
     * @return string|null
     */
    public function getBorderPoint()
    {
        return $this->borderPoint;
    }
    /**
     * Set borderPoint value
     * @param string $borderPoint
     * @return \Sabre\EnhancedAirBook\Structs\RailwayStationInfo
     */
    public function setBorderPoint($borderPoint = null)
    {
        $this->borderPoint = $borderPoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\RailwayStationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
