<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingQualifiers Structs
 * @subpackage Structs
 */
class PricingQualifiers extends AbstractStructBase
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Account
     */
    public $Account;
    /**
     * The AlternativePricing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AlternativePricing
     */
    public $AlternativePricing;
    /**
     * The BankersSellingRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BankersSellingRate;
    /**
     * The BargainFinder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BargainFinder
     */
    public $BargainFinder;
    /**
     * The BasicEconomyExclude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var string[]
     */
    public $BasicEconomyExclude;
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Brand[]
     */
    public $Brand;
    /**
     * The BuyingDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $BuyingDate;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Cabin;
    /**
     * The CommandPricing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CommandPricing[]
     */
    public $CommandPricing;
    /**
     * The Corporate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Corporate
     */
    public $Corporate;
    /**
     * The Fare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Fare
     */
    public $Fare;
    /**
     * The FareOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareOptions
     */
    public $FareOptions;
    /**
     * The ItineraryOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ItineraryOptions
     */
    public $ItineraryOptions;
    /**
     * The NameSelect
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\NameSelect[]
     */
    public $NameSelect;
    /**
     * The NetRemit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\NetRemit
     */
    public $NetRemit;
    /**
     * The Overrides
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Overrides
     */
    public $Overrides;
    /**
     * The PassengerStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PassengerStatus;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PassengerType[]
     */
    public $PassengerType;
    /**
     * The PlusUp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PlusUp
     */
    public $PlusUp;
    /**
     * The ShipsRegistry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipsRegistry;
    /**
     * The SpanishLargeFamilyDiscountLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpanishLargeFamilyDiscountLevel;
    /**
     * The SpecificFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SpecificFare[]
     */
    public $SpecificFare;
    /**
     * The SpecificPenalty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SpecificPenalty
     */
    public $SpecificPenalty;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Taxes
     */
    public $Taxes;
    /**
     * The ValidityDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ValidityDates[]
     */
    public $ValidityDates;
    /**
     * The AlternateCurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AlternateCurrencyCode;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The FareFocusExclude
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $FareFocusExclude;
    /**
     * The NoDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $NoDate;
    /**
     * The RoundTheWorld
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $RoundTheWorld;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Source;
    /**
     * Constructor method for PricingQualifiers
     * @uses PricingQualifiers::setAccount()
     * @uses PricingQualifiers::setAlternativePricing()
     * @uses PricingQualifiers::setBankersSellingRate()
     * @uses PricingQualifiers::setBargainFinder()
     * @uses PricingQualifiers::setBasicEconomyExclude()
     * @uses PricingQualifiers::setBrand()
     * @uses PricingQualifiers::setBuyingDate()
     * @uses PricingQualifiers::setCabin()
     * @uses PricingQualifiers::setCommandPricing()
     * @uses PricingQualifiers::setCorporate()
     * @uses PricingQualifiers::setFare()
     * @uses PricingQualifiers::setFareOptions()
     * @uses PricingQualifiers::setItineraryOptions()
     * @uses PricingQualifiers::setNameSelect()
     * @uses PricingQualifiers::setNetRemit()
     * @uses PricingQualifiers::setOverrides()
     * @uses PricingQualifiers::setPassengerStatus()
     * @uses PricingQualifiers::setPassengerType()
     * @uses PricingQualifiers::setPlusUp()
     * @uses PricingQualifiers::setShipsRegistry()
     * @uses PricingQualifiers::setSpanishLargeFamilyDiscountLevel()
     * @uses PricingQualifiers::setSpecificFare()
     * @uses PricingQualifiers::setSpecificPenalty()
     * @uses PricingQualifiers::setTaxes()
     * @uses PricingQualifiers::setValidityDates()
     * @uses PricingQualifiers::setAlternateCurrencyCode()
     * @uses PricingQualifiers::setCurrencyCode()
     * @uses PricingQualifiers::setFareFocusExclude()
     * @uses PricingQualifiers::setNoDate()
     * @uses PricingQualifiers::setRoundTheWorld()
     * @uses PricingQualifiers::setSource()
     * @param \Sabre\EnhancedAirBook\Structs\Account $account
     * @param \Sabre\EnhancedAirBook\Structs\AlternativePricing $alternativePricing
     * @param string $bankersSellingRate
     * @param \Sabre\EnhancedAirBook\Structs\BargainFinder $bargainFinder
     * @param string[] $basicEconomyExclude
     * @param \Sabre\EnhancedAirBook\Structs\Brand[] $brand
     * @param string $buyingDate
     * @param string $cabin
     * @param \Sabre\EnhancedAirBook\Structs\CommandPricing[] $commandPricing
     * @param \Sabre\EnhancedAirBook\Structs\Corporate $corporate
     * @param \Sabre\EnhancedAirBook\Structs\Fare $fare
     * @param \Sabre\EnhancedAirBook\Structs\FareOptions $fareOptions
     * @param \Sabre\EnhancedAirBook\Structs\ItineraryOptions $itineraryOptions
     * @param \Sabre\EnhancedAirBook\Structs\NameSelect[] $nameSelect
     * @param \Sabre\EnhancedAirBook\Structs\NetRemit $netRemit
     * @param \Sabre\EnhancedAirBook\Structs\Overrides $overrides
     * @param string $passengerStatus
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType[] $passengerType
     * @param \Sabre\EnhancedAirBook\Structs\PlusUp $plusUp
     * @param string $shipsRegistry
     * @param string $spanishLargeFamilyDiscountLevel
     * @param \Sabre\EnhancedAirBook\Structs\SpecificFare[] $specificFare
     * @param \Sabre\EnhancedAirBook\Structs\SpecificPenalty $specificPenalty
     * @param \Sabre\EnhancedAirBook\Structs\Taxes $taxes
     * @param \Sabre\EnhancedAirBook\Structs\ValidityDates[] $validityDates
     * @param string $alternateCurrencyCode
     * @param string $currencyCode
     * @param bool $fareFocusExclude
     * @param bool $noDate
     * @param bool $roundTheWorld
     * @param string $source
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Account $account = null, \Sabre\EnhancedAirBook\Structs\AlternativePricing $alternativePricing = null, $bankersSellingRate = null, \Sabre\EnhancedAirBook\Structs\BargainFinder $bargainFinder = null, array $basicEconomyExclude = array(), array $brand = array(), $buyingDate = null, $cabin = null, array $commandPricing = array(), \Sabre\EnhancedAirBook\Structs\Corporate $corporate = null, \Sabre\EnhancedAirBook\Structs\Fare $fare = null, \Sabre\EnhancedAirBook\Structs\FareOptions $fareOptions = null, \Sabre\EnhancedAirBook\Structs\ItineraryOptions $itineraryOptions = null, array $nameSelect = array(), \Sabre\EnhancedAirBook\Structs\NetRemit $netRemit = null, \Sabre\EnhancedAirBook\Structs\Overrides $overrides = null, $passengerStatus = null, array $passengerType = array(), \Sabre\EnhancedAirBook\Structs\PlusUp $plusUp = null, $shipsRegistry = null, $spanishLargeFamilyDiscountLevel = null, array $specificFare = array(), \Sabre\EnhancedAirBook\Structs\SpecificPenalty $specificPenalty = null, \Sabre\EnhancedAirBook\Structs\Taxes $taxes = null, array $validityDates = array(), $alternateCurrencyCode = null, $currencyCode = null, $fareFocusExclude = null, $noDate = null, $roundTheWorld = null, $source = null)
    {
        $this
            ->setAccount($account)
            ->setAlternativePricing($alternativePricing)
            ->setBankersSellingRate($bankersSellingRate)
            ->setBargainFinder($bargainFinder)
            ->setBasicEconomyExclude($basicEconomyExclude)
            ->setBrand($brand)
            ->setBuyingDate($buyingDate)
            ->setCabin($cabin)
            ->setCommandPricing($commandPricing)
            ->setCorporate($corporate)
            ->setFare($fare)
            ->setFareOptions($fareOptions)
            ->setItineraryOptions($itineraryOptions)
            ->setNameSelect($nameSelect)
            ->setNetRemit($netRemit)
            ->setOverrides($overrides)
            ->setPassengerStatus($passengerStatus)
            ->setPassengerType($passengerType)
            ->setPlusUp($plusUp)
            ->setShipsRegistry($shipsRegistry)
            ->setSpanishLargeFamilyDiscountLevel($spanishLargeFamilyDiscountLevel)
            ->setSpecificFare($specificFare)
            ->setSpecificPenalty($specificPenalty)
            ->setTaxes($taxes)
            ->setValidityDates($validityDates)
            ->setAlternateCurrencyCode($alternateCurrencyCode)
            ->setCurrencyCode($currencyCode)
            ->setFareFocusExclude($fareFocusExclude)
            ->setNoDate($noDate)
            ->setRoundTheWorld($roundTheWorld)
            ->setSource($source);
    }
    /**
     * Get Account value
     * @return \Sabre\EnhancedAirBook\Structs\Account|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \Sabre\EnhancedAirBook\Structs\Account $account
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setAccount(\Sabre\EnhancedAirBook\Structs\Account $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AlternativePricing value
     * @return \Sabre\EnhancedAirBook\Structs\AlternativePricing|null
     */
    public function getAlternativePricing()
    {
        return $this->AlternativePricing;
    }
    /**
     * Set AlternativePricing value
     * @param \Sabre\EnhancedAirBook\Structs\AlternativePricing $alternativePricing
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setAlternativePricing(\Sabre\EnhancedAirBook\Structs\AlternativePricing $alternativePricing = null)
    {
        $this->AlternativePricing = $alternativePricing;
        return $this;
    }
    /**
     * Get BankersSellingRate value
     * @return string|null
     */
    public function getBankersSellingRate()
    {
        return $this->BankersSellingRate;
    }
    /**
     * Set BankersSellingRate value
     * @param string $bankersSellingRate
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setBankersSellingRate($bankersSellingRate = null)
    {
        $this->BankersSellingRate = $bankersSellingRate;
        return $this;
    }
    /**
     * Get BargainFinder value
     * @return \Sabre\EnhancedAirBook\Structs\BargainFinder|null
     */
    public function getBargainFinder()
    {
        return $this->BargainFinder;
    }
    /**
     * Set BargainFinder value
     * @param \Sabre\EnhancedAirBook\Structs\BargainFinder $bargainFinder
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setBargainFinder(\Sabre\EnhancedAirBook\Structs\BargainFinder $bargainFinder = null)
    {
        $this->BargainFinder = $bargainFinder;
        return $this;
    }
    /**
     * Get BasicEconomyExclude value
     * @return string[]|null
     */
    public function getBasicEconomyExclude()
    {
        return $this->BasicEconomyExclude;
    }
    /**
     * Set BasicEconomyExclude value
     * @throws \InvalidArgumentException
     * @param string[] $basicEconomyExclude
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setBasicEconomyExclude(array $basicEconomyExclude = array())
    {
        $this->BasicEconomyExclude = $basicEconomyExclude;
        return $this;
    }
    /**
     * Add item to BasicEconomyExclude value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function addToBasicEconomyExclude($item)
    {
        $this->BasicEconomyExclude[] = $item;
        return $this;
    }
    /**
     * Get Brand value
     * @return \Sabre\EnhancedAirBook\Structs\Brand[]|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Brand[] $brand
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setBrand(array $brand = array())
    {
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Add item to Brand value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Brand $item
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function addToBrand(\Sabre\EnhancedAirBook\Structs\Brand $item)
    {
        $this->Brand[] = $item;
        return $this;
    }
    /**
     * Get BuyingDate value
     * @return string|null
     */
    public function getBuyingDate()
    {
        return $this->BuyingDate;
    }
    /**
     * Set BuyingDate value
     * @param string $buyingDate
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setBuyingDate($buyingDate = null)
    {
        $this->BuyingDate = $buyingDate;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setCabin($cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get CommandPricing value
     * @return \Sabre\EnhancedAirBook\Structs\CommandPricing[]|null
     */
    public function getCommandPricing()
    {
        return $this->CommandPricing;
    }
    /**
     * Set CommandPricing value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CommandPricing[] $commandPricing
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setCommandPricing(array $commandPricing = array())
    {
        $this->CommandPricing = $commandPricing;
        return $this;
    }
    /**
     * Add item to CommandPricing value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CommandPricing $item
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function addToCommandPricing(\Sabre\EnhancedAirBook\Structs\CommandPricing $item)
    {
        $this->CommandPricing[] = $item;
        return $this;
    }
    /**
     * Get Corporate value
     * @return \Sabre\EnhancedAirBook\Structs\Corporate|null
     */
    public function getCorporate()
    {
        return $this->Corporate;
    }
    /**
     * Set Corporate value
     * @param \Sabre\EnhancedAirBook\Structs\Corporate $corporate
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setCorporate(\Sabre\EnhancedAirBook\Structs\Corporate $corporate = null)
    {
        $this->Corporate = $corporate;
        return $this;
    }
    /**
     * Get Fare value
     * @return \Sabre\EnhancedAirBook\Structs\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \Sabre\EnhancedAirBook\Structs\Fare $fare
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setFare(\Sabre\EnhancedAirBook\Structs\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get FareOptions value
     * @return \Sabre\EnhancedAirBook\Structs\FareOptions|null
     */
    public function getFareOptions()
    {
        return $this->FareOptions;
    }
    /**
     * Set FareOptions value
     * @param \Sabre\EnhancedAirBook\Structs\FareOptions $fareOptions
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setFareOptions(\Sabre\EnhancedAirBook\Structs\FareOptions $fareOptions = null)
    {
        $this->FareOptions = $fareOptions;
        return $this;
    }
    /**
     * Get ItineraryOptions value
     * @return \Sabre\EnhancedAirBook\Structs\ItineraryOptions|null
     */
    public function getItineraryOptions()
    {
        return $this->ItineraryOptions;
    }
    /**
     * Set ItineraryOptions value
     * @param \Sabre\EnhancedAirBook\Structs\ItineraryOptions $itineraryOptions
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setItineraryOptions(\Sabre\EnhancedAirBook\Structs\ItineraryOptions $itineraryOptions = null)
    {
        $this->ItineraryOptions = $itineraryOptions;
        return $this;
    }
    /**
     * Get NameSelect value
     * @return \Sabre\EnhancedAirBook\Structs\NameSelect[]|null
     */
    public function getNameSelect()
    {
        return $this->NameSelect;
    }
    /**
     * Set NameSelect value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\NameSelect[] $nameSelect
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setNameSelect(array $nameSelect = array())
    {
        $this->NameSelect = $nameSelect;
        return $this;
    }
    /**
     * Add item to NameSelect value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\NameSelect $item
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function addToNameSelect(\Sabre\EnhancedAirBook\Structs\NameSelect $item)
    {
        $this->NameSelect[] = $item;
        return $this;
    }
    /**
     * Get NetRemit value
     * @return \Sabre\EnhancedAirBook\Structs\NetRemit|null
     */
    public function getNetRemit()
    {
        return $this->NetRemit;
    }
    /**
     * Set NetRemit value
     * @param \Sabre\EnhancedAirBook\Structs\NetRemit $netRemit
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setNetRemit(\Sabre\EnhancedAirBook\Structs\NetRemit $netRemit = null)
    {
        $this->NetRemit = $netRemit;
        return $this;
    }
    /**
     * Get Overrides value
     * @return \Sabre\EnhancedAirBook\Structs\Overrides|null
     */
    public function getOverrides()
    {
        return $this->Overrides;
    }
    /**
     * Set Overrides value
     * @param \Sabre\EnhancedAirBook\Structs\Overrides $overrides
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setOverrides(\Sabre\EnhancedAirBook\Structs\Overrides $overrides = null)
    {
        $this->Overrides = $overrides;
        return $this;
    }
    /**
     * Get PassengerStatus value
     * @return string|null
     */
    public function getPassengerStatus()
    {
        return $this->PassengerStatus;
    }
    /**
     * Set PassengerStatus value
     * @param string $passengerStatus
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setPassengerStatus($passengerStatus = null)
    {
        $this->PassengerStatus = $passengerStatus;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType[]|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType[] $passengerType
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setPassengerType(array $passengerType = array())
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Add item to PassengerType value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType $item
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function addToPassengerType(\Sabre\EnhancedAirBook\Structs\PassengerType $item)
    {
        $this->PassengerType[] = $item;
        return $this;
    }
    /**
     * Get PlusUp value
     * @return \Sabre\EnhancedAirBook\Structs\PlusUp|null
     */
    public function getPlusUp()
    {
        return $this->PlusUp;
    }
    /**
     * Set PlusUp value
     * @param \Sabre\EnhancedAirBook\Structs\PlusUp $plusUp
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setPlusUp(\Sabre\EnhancedAirBook\Structs\PlusUp $plusUp = null)
    {
        $this->PlusUp = $plusUp;
        return $this;
    }
    /**
     * Get ShipsRegistry value
     * @return string|null
     */
    public function getShipsRegistry()
    {
        return $this->ShipsRegistry;
    }
    /**
     * Set ShipsRegistry value
     * @param string $shipsRegistry
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setShipsRegistry($shipsRegistry = null)
    {
        $this->ShipsRegistry = $shipsRegistry;
        return $this;
    }
    /**
     * Get SpanishLargeFamilyDiscountLevel value
     * @return string|null
     */
    public function getSpanishLargeFamilyDiscountLevel()
    {
        return $this->SpanishLargeFamilyDiscountLevel;
    }
    /**
     * Set SpanishLargeFamilyDiscountLevel value
     * @uses \Sabre\EnhancedAirBook\Enums\SpanishLargeFamilyDiscountLevel::valueIsValid()
     * @uses \Sabre\EnhancedAirBook\Enums\SpanishLargeFamilyDiscountLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $spanishLargeFamilyDiscountLevel
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setSpanishLargeFamilyDiscountLevel($spanishLargeFamilyDiscountLevel = null)
    {
        $this->SpanishLargeFamilyDiscountLevel = $spanishLargeFamilyDiscountLevel;
        return $this;
    }
    /**
     * Get SpecificFare value
     * @return \Sabre\EnhancedAirBook\Structs\SpecificFare[]|null
     */
    public function getSpecificFare()
    {
        return $this->SpecificFare;
    }
    /**
     * Set SpecificFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\SpecificFare[] $specificFare
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setSpecificFare(array $specificFare = array())
    {
        $this->SpecificFare = $specificFare;
        return $this;
    }
    /**
     * Add item to SpecificFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\SpecificFare $item
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function addToSpecificFare(\Sabre\EnhancedAirBook\Structs\SpecificFare $item)
    {
        $this->SpecificFare[] = $item;
        return $this;
    }
    /**
     * Get SpecificPenalty value
     * @return \Sabre\EnhancedAirBook\Structs\SpecificPenalty|null
     */
    public function getSpecificPenalty()
    {
        return $this->SpecificPenalty;
    }
    /**
     * Set SpecificPenalty value
     * @param \Sabre\EnhancedAirBook\Structs\SpecificPenalty $specificPenalty
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setSpecificPenalty(\Sabre\EnhancedAirBook\Structs\SpecificPenalty $specificPenalty = null)
    {
        $this->SpecificPenalty = $specificPenalty;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\EnhancedAirBook\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\EnhancedAirBook\Structs\Taxes $taxes
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setTaxes(\Sabre\EnhancedAirBook\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get ValidityDates value
     * @return \Sabre\EnhancedAirBook\Structs\ValidityDates[]|null
     */
    public function getValidityDates()
    {
        return $this->ValidityDates;
    }
    /**
     * Set ValidityDates value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ValidityDates[] $validityDates
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setValidityDates(array $validityDates = array())
    {
        $this->ValidityDates = $validityDates;
        return $this;
    }
    /**
     * Add item to ValidityDates value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ValidityDates $item
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function addToValidityDates(\Sabre\EnhancedAirBook\Structs\ValidityDates $item)
    {
        $this->ValidityDates[] = $item;
        return $this;
    }
    /**
     * Get AlternateCurrencyCode value
     * @return string|null
     */
    public function getAlternateCurrencyCode()
    {
        return $this->AlternateCurrencyCode;
    }
    /**
     * Set AlternateCurrencyCode value
     * @param string $alternateCurrencyCode
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setAlternateCurrencyCode($alternateCurrencyCode = null)
    {
        $this->AlternateCurrencyCode = $alternateCurrencyCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get FareFocusExclude value
     * @return bool|null
     */
    public function getFareFocusExclude()
    {
        return $this->FareFocusExclude;
    }
    /**
     * Set FareFocusExclude value
     * @param bool $fareFocusExclude
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setFareFocusExclude($fareFocusExclude = null)
    {
        $this->FareFocusExclude = $fareFocusExclude;
        return $this;
    }
    /**
     * Get NoDate value
     * @return bool|null
     */
    public function getNoDate()
    {
        return $this->NoDate;
    }
    /**
     * Set NoDate value
     * @param bool $noDate
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setNoDate($noDate = null)
    {
        $this->NoDate = $noDate;
        return $this;
    }
    /**
     * Get RoundTheWorld value
     * @return bool|null
     */
    public function getRoundTheWorld()
    {
        return $this->RoundTheWorld;
    }
    /**
     * Set RoundTheWorld value
     * @param bool $roundTheWorld
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setRoundTheWorld($roundTheWorld = null)
    {
        $this->RoundTheWorld = $roundTheWorld;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public function setSource($source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PricingQualifiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
