<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceQuotePlus Structs
 * @subpackage Structs
 */
class PriceQuotePlus extends AbstractStructBase
{
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - documentation: When the value in the element is PQPLUS RESTRICTED, indicates the wholesaler does not have access to price quote the PNR
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Header;
    /**
     * The PassengerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PassengerInfo
     */
    public $PassengerInfo;
    /**
     * The TicketingInstructionsInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\TicketingInstructionsInfo
     */
    public $TicketingInstructionsInfo;
    /**
     * The FuturePricingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FuturePricingInfo
     */
    public $FuturePricingInfo;
    /**
     * The PACInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PACInfo
     */
    public $PACInfo;
    /**
     * The DomesticIntlInd
     * Meta informations extracted from the WSDL
     * - documentation: DomesticIntlInd is used to indicate if Itinerary is domestic or international.
     * @var string
     */
    public $DomesticIntlInd;
    /**
     * The PricingStatus
     * Meta informations extracted from the WSDL
     * - documentation: PricingStatus is used to indicate status of the fare stored in the PQ. The values can be different depending on invoking GDS (Sabre, Abacus, Infini).
     * @var string
     */
    public $PricingStatus;
    /**
     * The VerifyFareCalc
     * Meta informations extracted from the WSDL
     * - documentation: VerifyFareCalc is used to denote if Fare Calc requires any update/verification.
     * @var bool
     */
    public $VerifyFareCalc;
    /**
     * The ItineraryChanged
     * Meta informations extracted from the WSDL
     * - documentation: ItineraryChanged is used to indicate if original Itinerary has changed.
     * @var bool
     */
    public $ItineraryChanged;
    /**
     * The ManualFare
     * Meta informations extracted from the WSDL
     * - documentation: ManualFare is set when the PQ is created manually or when a fare is stored in the PQ as a manual fare.
     * @var bool
     */
    public $ManualFare;
    /**
     * The NegotiatedFare
     * Meta informations extracted from the WSDL
     * - documentation: NegotiatedFare is an indicator Pricing sends for certain types of fares to denote that the fare is not a published fare but is negotiated between the Carrier and the Agency.
     * @var bool
     */
    public $NegotiatedFare;
    /**
     * The SystemIndicator
     * Meta informations extracted from the WSDL
     * - documentation: SystemIndicator can have following values S(System), M(Manual) or A(Amended).
     * @var string
     */
    public $SystemIndicator;
    /**
     * The NUCSuppresion
     * Meta informations extracted from the WSDL
     * - documentation: NUCSuppresion is an indicator that INFINI uses to cause the amounts in the fare calculation to be overlaid with "IT" at time of ticket issuance.
     * @var bool
     */
    public $NUCSuppresion;
    /**
     * The SubjToGovtApproval
     * Meta informations extracted from the WSDL
     * - documentation: SubjToGovtApproval is and indicator that INFINI uses to denote that the fare is subject to Government approval.
     * @var bool
     */
    public $SubjToGovtApproval;
    /**
     * The IT_BT_Fare
     * Meta informations extracted from the WSDL
     * - documentation: IT_BT_Fare is used to indicate if the amount in the Fare box and Total box on the ticket should be overlaid with Bulk Ticket or Inclusive Tour Fare.
     * @var string
     */
    public $IT_BT_Fare;
    /**
     * The DisplayOnly
     * Meta informations extracted from the WSDL
     * - documentation: DisplayOnly is used to denote that stored fare cannot be ticketed for some reason.
     * @var bool
     */
    public $DisplayOnly;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - documentation: TourCode is a code that the airline may require to be present on a ticket for a particular fare.
     * @var string
     */
    public $TourCode;
    /**
     * The DiscountAmount
     * Meta informations extracted from the WSDL
     * - documentation: DiscountAmount is used by Abacus to indicate amount of used discount on a negotiated fare ticket.
     * @var string
     */
    public $DiscountAmount;
    /**
     * Constructor method for PriceQuotePlus
     * @uses PriceQuotePlus::setHeader()
     * @uses PriceQuotePlus::setPassengerInfo()
     * @uses PriceQuotePlus::setTicketingInstructionsInfo()
     * @uses PriceQuotePlus::setFuturePricingInfo()
     * @uses PriceQuotePlus::setPACInfo()
     * @uses PriceQuotePlus::setDomesticIntlInd()
     * @uses PriceQuotePlus::setPricingStatus()
     * @uses PriceQuotePlus::setVerifyFareCalc()
     * @uses PriceQuotePlus::setItineraryChanged()
     * @uses PriceQuotePlus::setManualFare()
     * @uses PriceQuotePlus::setNegotiatedFare()
     * @uses PriceQuotePlus::setSystemIndicator()
     * @uses PriceQuotePlus::setNUCSuppresion()
     * @uses PriceQuotePlus::setSubjToGovtApproval()
     * @uses PriceQuotePlus::setIT_BT_Fare()
     * @uses PriceQuotePlus::setDisplayOnly()
     * @uses PriceQuotePlus::setTourCode()
     * @uses PriceQuotePlus::setDiscountAmount()
     * @param string[] $header
     * @param \Sabre\EnhancedAirBook\Structs\PassengerInfo $passengerInfo
     * @param \Sabre\EnhancedAirBook\Structs\TicketingInstructionsInfo $ticketingInstructionsInfo
     * @param \Sabre\EnhancedAirBook\Structs\FuturePricingInfo $futurePricingInfo
     * @param \Sabre\EnhancedAirBook\Structs\PACInfo $pACInfo
     * @param string $domesticIntlInd
     * @param string $pricingStatus
     * @param bool $verifyFareCalc
     * @param bool $itineraryChanged
     * @param bool $manualFare
     * @param bool $negotiatedFare
     * @param string $systemIndicator
     * @param bool $nUCSuppresion
     * @param bool $subjToGovtApproval
     * @param string $iT_BT_Fare
     * @param bool $displayOnly
     * @param string $tourCode
     * @param string $discountAmount
     */
    public function __construct(array $header = array(), \Sabre\EnhancedAirBook\Structs\PassengerInfo $passengerInfo = null, \Sabre\EnhancedAirBook\Structs\TicketingInstructionsInfo $ticketingInstructionsInfo = null, \Sabre\EnhancedAirBook\Structs\FuturePricingInfo $futurePricingInfo = null, \Sabre\EnhancedAirBook\Structs\PACInfo $pACInfo = null, $domesticIntlInd = null, $pricingStatus = null, $verifyFareCalc = null, $itineraryChanged = null, $manualFare = null, $negotiatedFare = null, $systemIndicator = null, $nUCSuppresion = null, $subjToGovtApproval = null, $iT_BT_Fare = null, $displayOnly = null, $tourCode = null, $discountAmount = null)
    {
        $this
            ->setHeader($header)
            ->setPassengerInfo($passengerInfo)
            ->setTicketingInstructionsInfo($ticketingInstructionsInfo)
            ->setFuturePricingInfo($futurePricingInfo)
            ->setPACInfo($pACInfo)
            ->setDomesticIntlInd($domesticIntlInd)
            ->setPricingStatus($pricingStatus)
            ->setVerifyFareCalc($verifyFareCalc)
            ->setItineraryChanged($itineraryChanged)
            ->setManualFare($manualFare)
            ->setNegotiatedFare($negotiatedFare)
            ->setSystemIndicator($systemIndicator)
            ->setNUCSuppresion($nUCSuppresion)
            ->setSubjToGovtApproval($subjToGovtApproval)
            ->setIT_BT_Fare($iT_BT_Fare)
            ->setDisplayOnly($displayOnly)
            ->setTourCode($tourCode)
            ->setDiscountAmount($discountAmount);
    }
    /**
     * Get Header value
     * @return string[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param string[] $header
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setHeader(array $header = array())
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function addToHeader($item)
    {
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get PassengerInfo value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerInfo|null
     */
    public function getPassengerInfo()
    {
        return $this->PassengerInfo;
    }
    /**
     * Set PassengerInfo value
     * @param \Sabre\EnhancedAirBook\Structs\PassengerInfo $passengerInfo
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setPassengerInfo(\Sabre\EnhancedAirBook\Structs\PassengerInfo $passengerInfo = null)
    {
        $this->PassengerInfo = $passengerInfo;
        return $this;
    }
    /**
     * Get TicketingInstructionsInfo value
     * @return \Sabre\EnhancedAirBook\Structs\TicketingInstructionsInfo|null
     */
    public function getTicketingInstructionsInfo()
    {
        return $this->TicketingInstructionsInfo;
    }
    /**
     * Set TicketingInstructionsInfo value
     * @param \Sabre\EnhancedAirBook\Structs\TicketingInstructionsInfo $ticketingInstructionsInfo
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setTicketingInstructionsInfo(\Sabre\EnhancedAirBook\Structs\TicketingInstructionsInfo $ticketingInstructionsInfo = null)
    {
        $this->TicketingInstructionsInfo = $ticketingInstructionsInfo;
        return $this;
    }
    /**
     * Get FuturePricingInfo value
     * @return \Sabre\EnhancedAirBook\Structs\FuturePricingInfo|null
     */
    public function getFuturePricingInfo()
    {
        return $this->FuturePricingInfo;
    }
    /**
     * Set FuturePricingInfo value
     * @param \Sabre\EnhancedAirBook\Structs\FuturePricingInfo $futurePricingInfo
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setFuturePricingInfo(\Sabre\EnhancedAirBook\Structs\FuturePricingInfo $futurePricingInfo = null)
    {
        $this->FuturePricingInfo = $futurePricingInfo;
        return $this;
    }
    /**
     * Get PACInfo value
     * @return \Sabre\EnhancedAirBook\Structs\PACInfo|null
     */
    public function getPACInfo()
    {
        return $this->PACInfo;
    }
    /**
     * Set PACInfo value
     * @param \Sabre\EnhancedAirBook\Structs\PACInfo $pACInfo
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setPACInfo(\Sabre\EnhancedAirBook\Structs\PACInfo $pACInfo = null)
    {
        $this->PACInfo = $pACInfo;
        return $this;
    }
    /**
     * Get DomesticIntlInd value
     * @return string|null
     */
    public function getDomesticIntlInd()
    {
        return $this->DomesticIntlInd;
    }
    /**
     * Set DomesticIntlInd value
     * @param string $domesticIntlInd
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setDomesticIntlInd($domesticIntlInd = null)
    {
        $this->DomesticIntlInd = $domesticIntlInd;
        return $this;
    }
    /**
     * Get PricingStatus value
     * @return string|null
     */
    public function getPricingStatus()
    {
        return $this->PricingStatus;
    }
    /**
     * Set PricingStatus value
     * @param string $pricingStatus
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setPricingStatus($pricingStatus = null)
    {
        $this->PricingStatus = $pricingStatus;
        return $this;
    }
    /**
     * Get VerifyFareCalc value
     * @return bool|null
     */
    public function getVerifyFareCalc()
    {
        return $this->VerifyFareCalc;
    }
    /**
     * Set VerifyFareCalc value
     * @param bool $verifyFareCalc
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setVerifyFareCalc($verifyFareCalc = null)
    {
        $this->VerifyFareCalc = $verifyFareCalc;
        return $this;
    }
    /**
     * Get ItineraryChanged value
     * @return bool|null
     */
    public function getItineraryChanged()
    {
        return $this->ItineraryChanged;
    }
    /**
     * Set ItineraryChanged value
     * @param bool $itineraryChanged
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setItineraryChanged($itineraryChanged = null)
    {
        $this->ItineraryChanged = $itineraryChanged;
        return $this;
    }
    /**
     * Get ManualFare value
     * @return bool|null
     */
    public function getManualFare()
    {
        return $this->ManualFare;
    }
    /**
     * Set ManualFare value
     * @param bool $manualFare
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setManualFare($manualFare = null)
    {
        $this->ManualFare = $manualFare;
        return $this;
    }
    /**
     * Get NegotiatedFare value
     * @return bool|null
     */
    public function getNegotiatedFare()
    {
        return $this->NegotiatedFare;
    }
    /**
     * Set NegotiatedFare value
     * @param bool $negotiatedFare
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setNegotiatedFare($negotiatedFare = null)
    {
        $this->NegotiatedFare = $negotiatedFare;
        return $this;
    }
    /**
     * Get SystemIndicator value
     * @return string|null
     */
    public function getSystemIndicator()
    {
        return $this->SystemIndicator;
    }
    /**
     * Set SystemIndicator value
     * @param string $systemIndicator
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setSystemIndicator($systemIndicator = null)
    {
        $this->SystemIndicator = $systemIndicator;
        return $this;
    }
    /**
     * Get NUCSuppresion value
     * @return bool|null
     */
    public function getNUCSuppresion()
    {
        return $this->NUCSuppresion;
    }
    /**
     * Set NUCSuppresion value
     * @param bool $nUCSuppresion
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setNUCSuppresion($nUCSuppresion = null)
    {
        $this->NUCSuppresion = $nUCSuppresion;
        return $this;
    }
    /**
     * Get SubjToGovtApproval value
     * @return bool|null
     */
    public function getSubjToGovtApproval()
    {
        return $this->SubjToGovtApproval;
    }
    /**
     * Set SubjToGovtApproval value
     * @param bool $subjToGovtApproval
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setSubjToGovtApproval($subjToGovtApproval = null)
    {
        $this->SubjToGovtApproval = $subjToGovtApproval;
        return $this;
    }
    /**
     * Get IT_BT_Fare value
     * @return string|null
     */
    public function getIT_BT_Fare()
    {
        return $this->IT_BT_Fare;
    }
    /**
     * Set IT_BT_Fare value
     * @param string $iT_BT_Fare
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setIT_BT_Fare($iT_BT_Fare = null)
    {
        $this->IT_BT_Fare = $iT_BT_Fare;
        return $this;
    }
    /**
     * Get DisplayOnly value
     * @return bool|null
     */
    public function getDisplayOnly()
    {
        return $this->DisplayOnly;
    }
    /**
     * Set DisplayOnly value
     * @param bool $displayOnly
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setDisplayOnly($displayOnly = null)
    {
        $this->DisplayOnly = $displayOnly;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setTourCode($tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return string|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param string $discountAmount
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public function setDiscountAmount($discountAmount = null)
    {
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
