<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationDetails Structs
 * @subpackage Structs
 */
class LocationDetails extends AbstractStructBase
{
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The ExtendedLocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "ExtendedLocationCode" is used to return the extended vehicle pick up rental location code.
     * - use: optional
     * @var string
     */
    public $ExtendedLocationCode;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "LocationCode" is used to return the vehicle pick up rental location code.
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - documentation: "LocationName" is used to return the vehicle pick up rental location name.
     * - use: optional
     * @var string
     */
    public $LocationName;
    /**
     * Constructor method for LocationDetails
     * @uses LocationDetails::setContactNumbers()
     * @uses LocationDetails::setExtendedLocationCode()
     * @uses LocationDetails::setLocationCode()
     * @uses LocationDetails::setLocationName()
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @param string $extendedLocationCode
     * @param string $locationCode
     * @param string $locationName
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null, $extendedLocationCode = null, $locationCode = null, $locationName = null)
    {
        $this
            ->setContactNumbers($contactNumbers)
            ->setExtendedLocationCode($extendedLocationCode)
            ->setLocationCode($locationCode)
            ->setLocationName($locationName);
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\EnhancedAirBook\Structs\LocationDetails
     */
    public function setContactNumbers(\Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get ExtendedLocationCode value
     * @return string|null
     */
    public function getExtendedLocationCode()
    {
        return $this->ExtendedLocationCode;
    }
    /**
     * Set ExtendedLocationCode value
     * @param string $extendedLocationCode
     * @return \Sabre\EnhancedAirBook\Structs\LocationDetails
     */
    public function setExtendedLocationCode($extendedLocationCode = null)
    {
        $this->ExtendedLocationCode = $extendedLocationCode;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\EnhancedAirBook\Structs\LocationDetails
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \Sabre\EnhancedAirBook\Structs\LocationDetails
     */
    public function setLocationName($locationName = null)
    {
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\LocationDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
