<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteePrepaid Structs
 * @subpackage Structs
 */
class GuaranteePrepaid extends AbstractStructBase
{
    /**
     * The CancellationRefundAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CancellationRefundAmount[]
     */
    public $CancellationRefundAmount;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the guarantee amount.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The AmountPercentage
     * Meta informations extracted from the WSDL
     * - documentation: "AmountPercentage" is used to indicate whether the CancellationRefundAmount is an amount or a percentage.
     * - use: optional
     * @var string
     */
    public $AmountPercentage;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the guarantee currency code.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - documentation: "Ind" is used to return the type of guarantee, i.e. guarantee or a prepaid.
     * - use: optional
     * @var string
     */
    public $Ind;
    /**
     * Constructor method for GuaranteePrepaid
     * @uses GuaranteePrepaid::setCancellationRefundAmount()
     * @uses GuaranteePrepaid::setAmount()
     * @uses GuaranteePrepaid::setAmountPercentage()
     * @uses GuaranteePrepaid::setCurrencyCode()
     * @uses GuaranteePrepaid::setInd()
     * @param \Sabre\EnhancedAirBook\Structs\CancellationRefundAmount[] $cancellationRefundAmount
     * @param string $amount
     * @param string $amountPercentage
     * @param string $currencyCode
     * @param string $ind
     */
    public function __construct(array $cancellationRefundAmount = array(), $amount = null, $amountPercentage = null, $currencyCode = null, $ind = null)
    {
        $this
            ->setCancellationRefundAmount($cancellationRefundAmount)
            ->setAmount($amount)
            ->setAmountPercentage($amountPercentage)
            ->setCurrencyCode($currencyCode)
            ->setInd($ind);
    }
    /**
     * Get CancellationRefundAmount value
     * @return \Sabre\EnhancedAirBook\Structs\CancellationRefundAmount[]|null
     */
    public function getCancellationRefundAmount()
    {
        return $this->CancellationRefundAmount;
    }
    /**
     * Set CancellationRefundAmount value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CancellationRefundAmount[] $cancellationRefundAmount
     * @return \Sabre\EnhancedAirBook\Structs\GuaranteePrepaid
     */
    public function setCancellationRefundAmount(array $cancellationRefundAmount = array())
    {
        $this->CancellationRefundAmount = $cancellationRefundAmount;
        return $this;
    }
    /**
     * Add item to CancellationRefundAmount value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CancellationRefundAmount $item
     * @return \Sabre\EnhancedAirBook\Structs\GuaranteePrepaid
     */
    public function addToCancellationRefundAmount(\Sabre\EnhancedAirBook\Structs\CancellationRefundAmount $item)
    {
        $this->CancellationRefundAmount[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\EnhancedAirBook\Structs\GuaranteePrepaid
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AmountPercentage value
     * @return string|null
     */
    public function getAmountPercentage()
    {
        return $this->AmountPercentage;
    }
    /**
     * Set AmountPercentage value
     * @param string $amountPercentage
     * @return \Sabre\EnhancedAirBook\Structs\GuaranteePrepaid
     */
    public function setAmountPercentage($amountPercentage = null)
    {
        $this->AmountPercentage = $amountPercentage;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\EnhancedAirBook\Structs\GuaranteePrepaid
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Ind value
     * @return string|null
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param string $ind
     * @return \Sabre\EnhancedAirBook\Structs\GuaranteePrepaid
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\GuaranteePrepaid
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
