<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisclosureCarrier Structs
 * Meta informations extracted from the WSDL
 * - documentation: Disclosure carrier field (DCX) added. Optional data from DSS. If the DCX is not available, whole section is excluded from the RS.
 * @subpackage Structs
 */
class DisclosureCarrier extends AbstractStructBase
{
    /**
     * The Banner
     * Meta informations extracted from the WSDL
     * - documentation: "DisclosureCarrier/Banner" is used to return the disclosure carrier name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Banner;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return the disclosure carrier code associated with the particular vehicle segment
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for DisclosureCarrier
     * @uses DisclosureCarrier::setBanner()
     * @uses DisclosureCarrier::setCode()
     * @param string $banner
     * @param string $code
     */
    public function __construct($banner = null, $code = null)
    {
        $this
            ->setBanner($banner)
            ->setCode($code);
    }
    /**
     * Get Banner value
     * @return string|null
     */
    public function getBanner()
    {
        return $this->Banner;
    }
    /**
     * Set Banner value
     * @param string $banner
     * @return \Sabre\EnhancedAirBook\Structs\DisclosureCarrier
     */
    public function setBanner($banner = null)
    {
        $this->Banner = $banner;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\EnhancedAirBook\Structs\DisclosureCarrier
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\DisclosureCarrier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
