<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerInfo Structs
 * @subpackage Structs
 */
class CustomerInfo extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Address
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Passport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Passport[]
     */
    public $Passport;
    /**
     * The PaymentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PaymentInfo
     */
    public $PaymentInfo;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * Constructor method for CustomerInfo
     * @uses CustomerInfo::setAddress()
     * @uses CustomerInfo::setContactNumbers()
     * @uses CustomerInfo::setCustLoyalty()
     * @uses CustomerInfo::setPassport()
     * @uses CustomerInfo::setPaymentInfo()
     * @uses CustomerInfo::setPersonName()
     * @param \Sabre\EnhancedAirBook\Structs\Address $address
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @param \Sabre\EnhancedAirBook\Structs\CustLoyalty[] $custLoyalty
     * @param \Sabre\EnhancedAirBook\Structs\Passport[] $passport
     * @param \Sabre\EnhancedAirBook\Structs\PaymentInfo $paymentInfo
     * @param \Sabre\EnhancedAirBook\Structs\PersonName[] $personName
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Address $address = null, \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null, array $custLoyalty = array(), array $passport = array(), \Sabre\EnhancedAirBook\Structs\PaymentInfo $paymentInfo = null, array $personName = array())
    {
        $this
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setCustLoyalty($custLoyalty)
            ->setPassport($passport)
            ->setPaymentInfo($paymentInfo)
            ->setPersonName($personName);
    }
    /**
     * Get Address value
     * @return \Sabre\EnhancedAirBook\Structs\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\EnhancedAirBook\Structs\Address $address
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function setAddress(\Sabre\EnhancedAirBook\Structs\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function setContactNumbers(\Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CustLoyalty[] $custLoyalty
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CustLoyalty $item
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function addToCustLoyalty(\Sabre\EnhancedAirBook\Structs\CustLoyalty $item)
    {
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Passport value
     * @return \Sabre\EnhancedAirBook\Structs\Passport[]|null
     */
    public function getPassport()
    {
        return $this->Passport;
    }
    /**
     * Set Passport value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Passport[] $passport
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function setPassport(array $passport = array())
    {
        $this->Passport = $passport;
        return $this;
    }
    /**
     * Add item to Passport value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Passport $item
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function addToPassport(\Sabre\EnhancedAirBook\Structs\Passport $item)
    {
        $this->Passport[] = $item;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \Sabre\EnhancedAirBook\Structs\PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \Sabre\EnhancedAirBook\Structs\PaymentInfo $paymentInfo
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function setPaymentInfo(\Sabre\EnhancedAirBook\Structs\PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\EnhancedAirBook\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PersonName[] $personName
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PersonName $item
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public function addToPersonName(\Sabre\EnhancedAirBook\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\CustomerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
