<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactNumber Structs
 * @subpackage Structs
 */
class ContactNumber extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "LocationCode" is used to return the city code associated to the phone number.
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - documentation: "Phone" is used to return the telephone number. | "Phone" is used to return the telephone number associated with the particular credit card holder. | "Phone" is used to return the hotel's telephone number. | "Phone" is used to return
     * the phone number associated with the particular location. | "Phone" is used to return the collection site phone number associated with the vehicle reservation if applicable. | "Phone" is used to return the delivery site phone number associated with
     * the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $Phone;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - documentation: "Fax" is used to return the hotel's fax number. | "Fax" is used to return the fax number associated with the particular location.
     * - use: optional
     * @var string
     */
    public $Fax;
    /**
     * Constructor method for ContactNumber
     * @uses ContactNumber::setPersonName()
     * @uses ContactNumber::setLocationCode()
     * @uses ContactNumber::setPhone()
     * @uses ContactNumber::setRPH()
     * @uses ContactNumber::setId()
     * @uses ContactNumber::setFax()
     * @param \Sabre\EnhancedAirBook\Structs\PersonName[] $personName
     * @param string $locationCode
     * @param string $phone
     * @param string $rPH
     * @param string $id
     * @param string $fax
     */
    public function __construct(array $personName = array(), $locationCode = null, $phone = null, $rPH = null, $id = null, $fax = null)
    {
        $this
            ->setPersonName($personName)
            ->setLocationCode($locationCode)
            ->setPhone($phone)
            ->setRPH($rPH)
            ->setId($id)
            ->setFax($fax);
    }
    /**
     * Get PersonName value
     * @return \Sabre\EnhancedAirBook\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PersonName[] $personName
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumber
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PersonName $item
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumber
     */
    public function addToPersonName(\Sabre\EnhancedAirBook\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumber
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumber
     */
    public function setPhone($phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumber
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumber
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumber
     */
    public function setFax($fax = null)
    {
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
