<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CC_Info Structs
 * Meta informations extracted from the WSDL
 * - documentation: CC_Info is used as a container for payment Card details. Hold the payment card type, and the card number Example: PaymentCard Code="AX" Number="3XXXXXXXXXX8431"
 * @subpackage Structs
 */
class CC_Info extends AbstractStructBase
{
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PaymentCard[]
     */
    public $PaymentCard;
    /**
     * The Suppress
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Suppress;
    /**
     * The CardHolderInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CardHolderInfo
     */
    public $CardHolderInfo;
    /**
     * The PreferredCustomer
     * Meta informations extracted from the WSDL
     * - documentation: "PreferredCustomer" is used to indicate whether or not the cardholder is a preferred customer.
     * - use: optional
     * @var string
     */
    public $PreferredCustomer;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - documentation: "ShortText" is used to return miscellaneous credit card-related information.
     * - use: optional
     * @var string
     */
    public $ShortText;
    /**
     * Constructor method for CC_Info
     * @uses CC_Info::setPaymentCard()
     * @uses CC_Info::setSuppress()
     * @uses CC_Info::setCardHolderInfo()
     * @uses CC_Info::setPreferredCustomer()
     * @uses CC_Info::setShortText()
     * @param \Sabre\EnhancedAirBook\Structs\PaymentCard[] $paymentCard
     * @param bool $suppress
     * @param \Sabre\EnhancedAirBook\Structs\CardHolderInfo $cardHolderInfo
     * @param string $preferredCustomer
     * @param string $shortText
     */
    public function __construct(array $paymentCard = array(), $suppress = null, \Sabre\EnhancedAirBook\Structs\CardHolderInfo $cardHolderInfo = null, $preferredCustomer = null, $shortText = null)
    {
        $this
            ->setPaymentCard($paymentCard)
            ->setSuppress($suppress)
            ->setCardHolderInfo($cardHolderInfo)
            ->setPreferredCustomer($preferredCustomer)
            ->setShortText($shortText);
    }
    /**
     * Get PaymentCard value
     * @return \Sabre\EnhancedAirBook\Structs\PaymentCard[]|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PaymentCard[] $paymentCard
     * @return \Sabre\EnhancedAirBook\Structs\CC_Info
     */
    public function setPaymentCard(array $paymentCard = array())
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Add item to PaymentCard value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PaymentCard $item
     * @return \Sabre\EnhancedAirBook\Structs\CC_Info
     */
    public function addToPaymentCard(\Sabre\EnhancedAirBook\Structs\PaymentCard $item)
    {
        $this->PaymentCard[] = $item;
        return $this;
    }
    /**
     * Get Suppress value
     * @return bool|null
     */
    public function getSuppress()
    {
        return $this->Suppress;
    }
    /**
     * Set Suppress value
     * @param bool $suppress
     * @return \Sabre\EnhancedAirBook\Structs\CC_Info
     */
    public function setSuppress($suppress = null)
    {
        $this->Suppress = $suppress;
        return $this;
    }
    /**
     * Get CardHolderInfo value
     * @return \Sabre\EnhancedAirBook\Structs\CardHolderInfo|null
     */
    public function getCardHolderInfo()
    {
        return $this->CardHolderInfo;
    }
    /**
     * Set CardHolderInfo value
     * @param \Sabre\EnhancedAirBook\Structs\CardHolderInfo $cardHolderInfo
     * @return \Sabre\EnhancedAirBook\Structs\CC_Info
     */
    public function setCardHolderInfo(\Sabre\EnhancedAirBook\Structs\CardHolderInfo $cardHolderInfo = null)
    {
        $this->CardHolderInfo = $cardHolderInfo;
        return $this;
    }
    /**
     * Get PreferredCustomer value
     * @return string|null
     */
    public function getPreferredCustomer()
    {
        return $this->PreferredCustomer;
    }
    /**
     * Set PreferredCustomer value
     * @param string $preferredCustomer
     * @return \Sabre\EnhancedAirBook\Structs\CC_Info
     */
    public function setPreferredCustomer($preferredCustomer = null)
    {
        $this->PreferredCustomer = $preferredCustomer;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\EnhancedAirBook\Structs\CC_Info
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\CC_Info
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
