<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Associations Structs
 * @subpackage Structs
 */
class Associations extends AbstractStructBase
{
    /**
     * The CarrierCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CarrierCode[]
     */
    public $CarrierCode;
    /**
     * The CountForSegmentAssociatedID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CountForSegmentAssociatedID;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\DepartureDate[]
     */
    public $DepartureDate;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\DestinationLocation[]
     */
    public $DestinationLocation;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FlightNumber[]
     */
    public $FlightNumber;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\OriginLocation[]
     */
    public $OriginLocation;
    /**
     * The PNR_Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PNR_Segment[]
     */
    public $PNR_Segment;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ResBookDesigCode[]
     */
    public $ResBookDesigCode;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\StatusCode[]
     */
    public $StatusCode;
    /**
     * Constructor method for Associations
     * @uses Associations::setCarrierCode()
     * @uses Associations::setCountForSegmentAssociatedID()
     * @uses Associations::setDepartureDate()
     * @uses Associations::setDestinationLocation()
     * @uses Associations::setFlightNumber()
     * @uses Associations::setOriginLocation()
     * @uses Associations::setPNR_Segment()
     * @uses Associations::setResBookDesigCode()
     * @uses Associations::setStatusCode()
     * @param \Sabre\EnhancedAirBook\Structs\CarrierCode[] $carrierCode
     * @param string $countForSegmentAssociatedID
     * @param \Sabre\EnhancedAirBook\Structs\DepartureDate[] $departureDate
     * @param \Sabre\EnhancedAirBook\Structs\DestinationLocation[] $destinationLocation
     * @param \Sabre\EnhancedAirBook\Structs\FlightNumber[] $flightNumber
     * @param \Sabre\EnhancedAirBook\Structs\OriginLocation[] $originLocation
     * @param \Sabre\EnhancedAirBook\Structs\PNR_Segment[] $pNR_Segment
     * @param \Sabre\EnhancedAirBook\Structs\ResBookDesigCode[] $resBookDesigCode
     * @param \Sabre\EnhancedAirBook\Structs\StatusCode[] $statusCode
     */
    public function __construct(array $carrierCode = array(), $countForSegmentAssociatedID = null, array $departureDate = array(), array $destinationLocation = array(), array $flightNumber = array(), array $originLocation = array(), array $pNR_Segment = array(), array $resBookDesigCode = array(), array $statusCode = array())
    {
        $this
            ->setCarrierCode($carrierCode)
            ->setCountForSegmentAssociatedID($countForSegmentAssociatedID)
            ->setDepartureDate($departureDate)
            ->setDestinationLocation($destinationLocation)
            ->setFlightNumber($flightNumber)
            ->setOriginLocation($originLocation)
            ->setPNR_Segment($pNR_Segment)
            ->setResBookDesigCode($resBookDesigCode)
            ->setStatusCode($statusCode);
    }
    /**
     * Get CarrierCode value
     * @return \Sabre\EnhancedAirBook\Structs\CarrierCode[]|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CarrierCode[] $carrierCode
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setCarrierCode(array $carrierCode = array())
    {
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Add item to CarrierCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CarrierCode $item
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function addToCarrierCode(\Sabre\EnhancedAirBook\Structs\CarrierCode $item)
    {
        $this->CarrierCode[] = $item;
        return $this;
    }
    /**
     * Get CountForSegmentAssociatedID value
     * @return string|null
     */
    public function getCountForSegmentAssociatedID()
    {
        return $this->CountForSegmentAssociatedID;
    }
    /**
     * Set CountForSegmentAssociatedID value
     * @param string $countForSegmentAssociatedID
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setCountForSegmentAssociatedID($countForSegmentAssociatedID = null)
    {
        $this->CountForSegmentAssociatedID = $countForSegmentAssociatedID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return \Sabre\EnhancedAirBook\Structs\DepartureDate[]|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\DepartureDate[] $departureDate
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setDepartureDate(array $departureDate = array())
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Add item to DepartureDate value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\DepartureDate $item
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function addToDepartureDate(\Sabre\EnhancedAirBook\Structs\DepartureDate $item)
    {
        $this->DepartureDate[] = $item;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\EnhancedAirBook\Structs\DestinationLocation[]|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\DestinationLocation[] $destinationLocation
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setDestinationLocation(array $destinationLocation = array())
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Add item to DestinationLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\DestinationLocation $item
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function addToDestinationLocation(\Sabre\EnhancedAirBook\Structs\DestinationLocation $item)
    {
        $this->DestinationLocation[] = $item;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return \Sabre\EnhancedAirBook\Structs\FlightNumber[]|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FlightNumber[] $flightNumber
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setFlightNumber(array $flightNumber = array())
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Add item to FlightNumber value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FlightNumber $item
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function addToFlightNumber(\Sabre\EnhancedAirBook\Structs\FlightNumber $item)
    {
        $this->FlightNumber[] = $item;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\EnhancedAirBook\Structs\OriginLocation[]|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\OriginLocation[] $originLocation
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setOriginLocation(array $originLocation = array())
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Add item to OriginLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\OriginLocation $item
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function addToOriginLocation(\Sabre\EnhancedAirBook\Structs\OriginLocation $item)
    {
        $this->OriginLocation[] = $item;
        return $this;
    }
    /**
     * Get PNR_Segment value
     * @return \Sabre\EnhancedAirBook\Structs\PNR_Segment[]|null
     */
    public function getPNR_Segment()
    {
        return $this->PNR_Segment;
    }
    /**
     * Set PNR_Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PNR_Segment[] $pNR_Segment
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setPNR_Segment(array $pNR_Segment = array())
    {
        $this->PNR_Segment = $pNR_Segment;
        return $this;
    }
    /**
     * Add item to PNR_Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PNR_Segment $item
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function addToPNR_Segment(\Sabre\EnhancedAirBook\Structs\PNR_Segment $item)
    {
        $this->PNR_Segment[] = $item;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return \Sabre\EnhancedAirBook\Structs\ResBookDesigCode[]|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ResBookDesigCode[] $resBookDesigCode
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setResBookDesigCode(array $resBookDesigCode = array())
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Add item to ResBookDesigCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ResBookDesigCode $item
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function addToResBookDesigCode(\Sabre\EnhancedAirBook\Structs\ResBookDesigCode $item)
    {
        $this->ResBookDesigCode[] = $item;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return \Sabre\EnhancedAirBook\Structs\StatusCode[]|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\StatusCode[] $statusCode
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function setStatusCode(array $statusCode = array())
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Add item to StatusCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\StatusCode $item
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public function addToStatusCode(\Sabre\EnhancedAirBook\Structs\StatusCode $item)
    {
        $this->StatusCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Associations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
