<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociatedData Structs
 * @subpackage Structs
 */
class AssociatedData extends AbstractStructBase
{
    /**
     * The AssociatedDataItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AssociatedDataItem[]
     */
    public $AssociatedDataItem;
    /**
     * Constructor method for AssociatedData
     * @uses AssociatedData::setAssociatedDataItem()
     * @param \Sabre\EnhancedAirBook\Structs\AssociatedDataItem[] $associatedDataItem
     */
    public function __construct(array $associatedDataItem = array())
    {
        $this
            ->setAssociatedDataItem($associatedDataItem);
    }
    /**
     * Get AssociatedDataItem value
     * @return \Sabre\EnhancedAirBook\Structs\AssociatedDataItem[]|null
     */
    public function getAssociatedDataItem()
    {
        return $this->AssociatedDataItem;
    }
    /**
     * Set AssociatedDataItem value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\AssociatedDataItem[] $associatedDataItem
     * @return \Sabre\EnhancedAirBook\Structs\AssociatedData
     */
    public function setAssociatedDataItem(array $associatedDataItem = array())
    {
        $this->AssociatedDataItem = $associatedDataItem;
        return $this;
    }
    /**
     * Add item to AssociatedDataItem value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\AssociatedDataItem $item
     * @return \Sabre\EnhancedAirBook\Structs\AssociatedData
     */
    public function addToAssociatedDataItem(\Sabre\EnhancedAirBook\Structs\AssociatedDataItem $item)
    {
        $this->AssociatedDataItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\AssociatedData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
