<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryPricingInfo Structs
 * @subpackage Structs
 */
class AirItineraryPricingInfo extends AbstractStructBase
{
    /**
     * The AncillaryFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AncillaryFees[]
     */
    public $AncillaryFees;
    /**
     * The BaggageProvisions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BaggageProvisions[]
     */
    public $BaggageProvisions;
    /**
     * The FareCalculation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareCalculation
     */
    public $FareCalculation;
    /**
     * The FareCalculationBreakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareCalculationBreakdown[]
     */
    public $FareCalculationBreakdown;
    /**
     * The ItinTotalFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ItinTotalFare[]
     */
    public $ItinTotalFare;
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PassengerTypeQuantity[]
     */
    public $PassengerTypeQuantity;
    /**
     * The PTC_FareBreakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown[]
     */
    public $PTC_FareBreakdown;
    /**
     * The SpecificPenalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SpecificPenalty[]
     */
    public $SpecificPenalty;
    /**
     * The TicketingFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\TicketingFees[]
     */
    public $TicketingFees;
    /**
     * The SolutionSequenceNmbr
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SolutionSequenceNmbr;
    /**
     * The PrivateFareInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PrivateFareInformation
     */
    public $PrivateFareInformation;
    /**
     * Constructor method for AirItineraryPricingInfo
     * @uses AirItineraryPricingInfo::setAncillaryFees()
     * @uses AirItineraryPricingInfo::setBaggageProvisions()
     * @uses AirItineraryPricingInfo::setFareCalculation()
     * @uses AirItineraryPricingInfo::setFareCalculationBreakdown()
     * @uses AirItineraryPricingInfo::setItinTotalFare()
     * @uses AirItineraryPricingInfo::setPassengerTypeQuantity()
     * @uses AirItineraryPricingInfo::setPTC_FareBreakdown()
     * @uses AirItineraryPricingInfo::setSpecificPenalty()
     * @uses AirItineraryPricingInfo::setTicketingFees()
     * @uses AirItineraryPricingInfo::setSolutionSequenceNmbr()
     * @uses AirItineraryPricingInfo::setPrivateFareInformation()
     * @param \Sabre\EnhancedAirBook\Structs\AncillaryFees[] $ancillaryFees
     * @param \Sabre\EnhancedAirBook\Structs\BaggageProvisions[] $baggageProvisions
     * @param \Sabre\EnhancedAirBook\Structs\FareCalculation $fareCalculation
     * @param \Sabre\EnhancedAirBook\Structs\FareCalculationBreakdown[] $fareCalculationBreakdown
     * @param \Sabre\EnhancedAirBook\Structs\ItinTotalFare[] $itinTotalFare
     * @param \Sabre\EnhancedAirBook\Structs\PassengerTypeQuantity[] $passengerTypeQuantity
     * @param \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown[] $pTC_FareBreakdown
     * @param \Sabre\EnhancedAirBook\Structs\SpecificPenalty[] $specificPenalty
     * @param \Sabre\EnhancedAirBook\Structs\TicketingFees[] $ticketingFees
     * @param string $solutionSequenceNmbr
     * @param \Sabre\EnhancedAirBook\Structs\PrivateFareInformation $privateFareInformation
     */
    public function __construct(array $ancillaryFees = array(), array $baggageProvisions = array(), \Sabre\EnhancedAirBook\Structs\FareCalculation $fareCalculation = null, array $fareCalculationBreakdown = array(), array $itinTotalFare = array(), array $passengerTypeQuantity = array(), array $pTC_FareBreakdown = array(), array $specificPenalty = array(), array $ticketingFees = array(), $solutionSequenceNmbr = null, \Sabre\EnhancedAirBook\Structs\PrivateFareInformation $privateFareInformation = null)
    {
        $this
            ->setAncillaryFees($ancillaryFees)
            ->setBaggageProvisions($baggageProvisions)
            ->setFareCalculation($fareCalculation)
            ->setFareCalculationBreakdown($fareCalculationBreakdown)
            ->setItinTotalFare($itinTotalFare)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setPTC_FareBreakdown($pTC_FareBreakdown)
            ->setSpecificPenalty($specificPenalty)
            ->setTicketingFees($ticketingFees)
            ->setSolutionSequenceNmbr($solutionSequenceNmbr)
            ->setPrivateFareInformation($privateFareInformation);
    }
    /**
     * Get AncillaryFees value
     * @return \Sabre\EnhancedAirBook\Structs\AncillaryFees[]|null
     */
    public function getAncillaryFees()
    {
        return $this->AncillaryFees;
    }
    /**
     * Set AncillaryFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\AncillaryFees[] $ancillaryFees
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setAncillaryFees(array $ancillaryFees = array())
    {
        $this->AncillaryFees = $ancillaryFees;
        return $this;
    }
    /**
     * Add item to AncillaryFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\AncillaryFees $item
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function addToAncillaryFees(\Sabre\EnhancedAirBook\Structs\AncillaryFees $item)
    {
        $this->AncillaryFees[] = $item;
        return $this;
    }
    /**
     * Get BaggageProvisions value
     * @return \Sabre\EnhancedAirBook\Structs\BaggageProvisions[]|null
     */
    public function getBaggageProvisions()
    {
        return $this->BaggageProvisions;
    }
    /**
     * Set BaggageProvisions value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\BaggageProvisions[] $baggageProvisions
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setBaggageProvisions(array $baggageProvisions = array())
    {
        $this->BaggageProvisions = $baggageProvisions;
        return $this;
    }
    /**
     * Add item to BaggageProvisions value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\BaggageProvisions $item
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function addToBaggageProvisions(\Sabre\EnhancedAirBook\Structs\BaggageProvisions $item)
    {
        $this->BaggageProvisions[] = $item;
        return $this;
    }
    /**
     * Get FareCalculation value
     * @return \Sabre\EnhancedAirBook\Structs\FareCalculation|null
     */
    public function getFareCalculation()
    {
        return $this->FareCalculation;
    }
    /**
     * Set FareCalculation value
     * @param \Sabre\EnhancedAirBook\Structs\FareCalculation $fareCalculation
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setFareCalculation(\Sabre\EnhancedAirBook\Structs\FareCalculation $fareCalculation = null)
    {
        $this->FareCalculation = $fareCalculation;
        return $this;
    }
    /**
     * Get FareCalculationBreakdown value
     * @return \Sabre\EnhancedAirBook\Structs\FareCalculationBreakdown[]|null
     */
    public function getFareCalculationBreakdown()
    {
        return $this->FareCalculationBreakdown;
    }
    /**
     * Set FareCalculationBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FareCalculationBreakdown[] $fareCalculationBreakdown
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setFareCalculationBreakdown(array $fareCalculationBreakdown = array())
    {
        $this->FareCalculationBreakdown = $fareCalculationBreakdown;
        return $this;
    }
    /**
     * Add item to FareCalculationBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FareCalculationBreakdown $item
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function addToFareCalculationBreakdown(\Sabre\EnhancedAirBook\Structs\FareCalculationBreakdown $item)
    {
        $this->FareCalculationBreakdown[] = $item;
        return $this;
    }
    /**
     * Get ItinTotalFare value
     * @return \Sabre\EnhancedAirBook\Structs\ItinTotalFare[]|null
     */
    public function getItinTotalFare()
    {
        return $this->ItinTotalFare;
    }
    /**
     * Set ItinTotalFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ItinTotalFare[] $itinTotalFare
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setItinTotalFare(array $itinTotalFare = array())
    {
        $this->ItinTotalFare = $itinTotalFare;
        return $this;
    }
    /**
     * Add item to ItinTotalFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ItinTotalFare $item
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function addToItinTotalFare(\Sabre\EnhancedAirBook\Structs\ItinTotalFare $item)
    {
        $this->ItinTotalFare[] = $item;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerTypeQuantity[]|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerTypeQuantity[] $passengerTypeQuantity
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setPassengerTypeQuantity(array $passengerTypeQuantity = array())
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Add item to PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PassengerTypeQuantity $item
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function addToPassengerTypeQuantity(\Sabre\EnhancedAirBook\Structs\PassengerTypeQuantity $item)
    {
        $this->PassengerTypeQuantity[] = $item;
        return $this;
    }
    /**
     * Get PTC_FareBreakdown value
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown[]|null
     */
    public function getPTC_FareBreakdown()
    {
        return $this->PTC_FareBreakdown;
    }
    /**
     * Set PTC_FareBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown[] $pTC_FareBreakdown
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setPTC_FareBreakdown(array $pTC_FareBreakdown = array())
    {
        $this->PTC_FareBreakdown = $pTC_FareBreakdown;
        return $this;
    }
    /**
     * Add item to PTC_FareBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown $item
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function addToPTC_FareBreakdown(\Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown $item)
    {
        $this->PTC_FareBreakdown[] = $item;
        return $this;
    }
    /**
     * Get SpecificPenalty value
     * @return \Sabre\EnhancedAirBook\Structs\SpecificPenalty[]|null
     */
    public function getSpecificPenalty()
    {
        return $this->SpecificPenalty;
    }
    /**
     * Set SpecificPenalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\SpecificPenalty[] $specificPenalty
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setSpecificPenalty(array $specificPenalty = array())
    {
        $this->SpecificPenalty = $specificPenalty;
        return $this;
    }
    /**
     * Add item to SpecificPenalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\SpecificPenalty $item
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function addToSpecificPenalty(\Sabre\EnhancedAirBook\Structs\SpecificPenalty $item)
    {
        $this->SpecificPenalty[] = $item;
        return $this;
    }
    /**
     * Get TicketingFees value
     * @return \Sabre\EnhancedAirBook\Structs\TicketingFees[]|null
     */
    public function getTicketingFees()
    {
        return $this->TicketingFees;
    }
    /**
     * Set TicketingFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\TicketingFees[] $ticketingFees
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setTicketingFees(array $ticketingFees = array())
    {
        $this->TicketingFees = $ticketingFees;
        return $this;
    }
    /**
     * Add item to TicketingFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\TicketingFees $item
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function addToTicketingFees(\Sabre\EnhancedAirBook\Structs\TicketingFees $item)
    {
        $this->TicketingFees[] = $item;
        return $this;
    }
    /**
     * Get SolutionSequenceNmbr value
     * @return string|null
     */
    public function getSolutionSequenceNmbr()
    {
        return $this->SolutionSequenceNmbr;
    }
    /**
     * Set SolutionSequenceNmbr value
     * @param string $solutionSequenceNmbr
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setSolutionSequenceNmbr($solutionSequenceNmbr = null)
    {
        $this->SolutionSequenceNmbr = $solutionSequenceNmbr;
        return $this;
    }
    /**
     * Get PrivateFareInformation value
     * @return \Sabre\EnhancedAirBook\Structs\PrivateFareInformation|null
     */
    public function getPrivateFareInformation()
    {
        return $this->PrivateFareInformation;
    }
    /**
     * Set PrivateFareInformation value
     * @param \Sabre\EnhancedAirBook\Structs\PrivateFareInformation $privateFareInformation
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public function setPrivateFareInformation(\Sabre\EnhancedAirBook\Structs\PrivateFareInformation $privateFareInformation = null)
    {
        $this->PrivateFareInformation = $privateFareInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
