<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account Structs
 * @subpackage Structs
 */
class Account extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * @var string[]
     */
    public $Code;
    /**
     * The Force
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Force;
    /**
     * Constructor method for Account
     * @uses Account::setCode()
     * @uses Account::setForce()
     * @param string[] $code
     * @param string $force
     */
    public function __construct(array $code = array(), $force = null)
    {
        $this
            ->setCode($code)
            ->setForce($force);
    }
    /**
     * Get Code value
     * @return string[]|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @throws \InvalidArgumentException
     * @param string[] $code
     * @return \Sabre\EnhancedAirBook\Structs\Account
     */
    public function setCode(array $code = array())
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Add item to Code value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\Account
     */
    public function addToCode($item)
    {
        $this->Code[] = $item;
        return $this;
    }
    /**
     * Get Force value
     * @return string|null
     */
    public function getForce()
    {
        return $this->Force;
    }
    /**
     * Set Force value
     * @param string $force
     * @return \Sabre\EnhancedAirBook\Structs\Account
     */
    public function setForce($force = null)
    {
        $this->Force = $force;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Account
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
