<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalTax Structs
 * Meta informations extracted from the WSDL
 * - documentation: "TotalTax" is used to return the total tax details | "TotalTax" is used to return the total tax details
 * @subpackage Structs
 */
class TotalTax extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Tax[]
     */
    public $Tax;
    /**
     * Constructor method for TotalTax
     * @uses TotalTax::setAmount()
     * @uses TotalTax::setCurrencyCode()
     * @uses TotalTax::setTax()
     * @param string $amount
     * @param string $currencyCode
     * @param \Sabre\EnhancedAirBook\Structs\Tax[] $tax
     */
    public function __construct($amount = null, $currencyCode = null, array $tax = array())
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setTax($tax);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\EnhancedAirBook\Structs\TotalTax
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\EnhancedAirBook\Structs\TotalTax
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\EnhancedAirBook\Structs\Tax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Tax[] $tax
     * @return \Sabre\EnhancedAirBook\Structs\TotalTax
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Tax $item
     * @return \Sabre\EnhancedAirBook\Structs\TotalTax
     */
    public function addToTax(\Sabre\EnhancedAirBook\Structs\Tax $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\TotalTax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
