<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceType Structs
 * @subpackage Structs
 */
class ServiceType extends AbstractStructBase
{
    /**
     * The ServiceLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ServiceLevelType
     */
    public $ServiceLevel;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\EquipmentType
     */
    public $Equipment;
    /**
     * The MeetAndGreetInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MeetAndGreetInd;
    /**
     * The MaximumBaggage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaximumBaggage;
    /**
     * The MaximumPassengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaximumPassengers;
    /**
     * Constructor method for ServiceType
     * @uses ServiceType::setServiceLevel()
     * @uses ServiceType::setEquipment()
     * @uses ServiceType::setMeetAndGreetInd()
     * @uses ServiceType::setMaximumBaggage()
     * @uses ServiceType::setMaximumPassengers()
     * @param \Sabre\EnhancedAirBook\Structs\ServiceLevelType $serviceLevel
     * @param \Sabre\EnhancedAirBook\Structs\EquipmentType $equipment
     * @param bool $meetAndGreetInd
     * @param int $maximumBaggage
     * @param int $maximumPassengers
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\ServiceLevelType $serviceLevel = null, \Sabre\EnhancedAirBook\Structs\EquipmentType $equipment = null, $meetAndGreetInd = null, $maximumBaggage = null, $maximumPassengers = null)
    {
        $this
            ->setServiceLevel($serviceLevel)
            ->setEquipment($equipment)
            ->setMeetAndGreetInd($meetAndGreetInd)
            ->setMaximumBaggage($maximumBaggage)
            ->setMaximumPassengers($maximumPassengers);
    }
    /**
     * Get ServiceLevel value
     * @return \Sabre\EnhancedAirBook\Structs\ServiceLevelType|null
     */
    public function getServiceLevel()
    {
        return $this->ServiceLevel;
    }
    /**
     * Set ServiceLevel value
     * @param \Sabre\EnhancedAirBook\Structs\ServiceLevelType $serviceLevel
     * @return \Sabre\EnhancedAirBook\Structs\ServiceType
     */
    public function setServiceLevel(\Sabre\EnhancedAirBook\Structs\ServiceLevelType $serviceLevel = null)
    {
        $this->ServiceLevel = $serviceLevel;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \Sabre\EnhancedAirBook\Structs\EquipmentType|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \Sabre\EnhancedAirBook\Structs\EquipmentType $equipment
     * @return \Sabre\EnhancedAirBook\Structs\ServiceType
     */
    public function setEquipment(\Sabre\EnhancedAirBook\Structs\EquipmentType $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get MeetAndGreetInd value
     * @return bool|null
     */
    public function getMeetAndGreetInd()
    {
        return $this->MeetAndGreetInd;
    }
    /**
     * Set MeetAndGreetInd value
     * @param bool $meetAndGreetInd
     * @return \Sabre\EnhancedAirBook\Structs\ServiceType
     */
    public function setMeetAndGreetInd($meetAndGreetInd = null)
    {
        $this->MeetAndGreetInd = $meetAndGreetInd;
        return $this;
    }
    /**
     * Get MaximumBaggage value
     * @return int|null
     */
    public function getMaximumBaggage()
    {
        return $this->MaximumBaggage;
    }
    /**
     * Set MaximumBaggage value
     * @param int $maximumBaggage
     * @return \Sabre\EnhancedAirBook\Structs\ServiceType
     */
    public function setMaximumBaggage($maximumBaggage = null)
    {
        $this->MaximumBaggage = $maximumBaggage;
        return $this;
    }
    /**
     * Get MaximumPassengers value
     * @return int|null
     */
    public function getMaximumPassengers()
    {
        return $this->MaximumPassengers;
    }
    /**
     * Set MaximumPassengers value
     * @param int $maximumPassengers
     * @return \Sabre\EnhancedAirBook\Structs\ServiceType
     */
    public function setMaximumPassengers($maximumPassengers = null)
    {
        $this->MaximumPassengers = $maximumPassengers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\ServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
