<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceQuote Structs
 * @subpackage Structs
 */
class PriceQuote extends AbstractStructBase
{
    /**
     * The MiscInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public $MiscInformation;
    /**
     * The PricedItinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PricedItinerary[]
     */
    public $PricedItinerary;
    /**
     * The ResponseHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ResponseHeader
     */
    public $ResponseHeader;
    /**
     * The PriceQuotePlus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PriceQuotePlus
     */
    public $PriceQuotePlus;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for PriceQuote
     * @uses PriceQuote::setMiscInformation()
     * @uses PriceQuote::setPricedItinerary()
     * @uses PriceQuote::setResponseHeader()
     * @uses PriceQuote::setPriceQuotePlus()
     * @uses PriceQuote::setRPH()
     * @param \Sabre\EnhancedAirBook\Structs\MiscInformation $miscInformation
     * @param \Sabre\EnhancedAirBook\Structs\PricedItinerary[] $pricedItinerary
     * @param \Sabre\EnhancedAirBook\Structs\ResponseHeader $responseHeader
     * @param \Sabre\EnhancedAirBook\Structs\PriceQuotePlus $priceQuotePlus
     * @param string $rPH
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\MiscInformation $miscInformation = null, array $pricedItinerary = array(), \Sabre\EnhancedAirBook\Structs\ResponseHeader $responseHeader = null, \Sabre\EnhancedAirBook\Structs\PriceQuotePlus $priceQuotePlus = null, $rPH = null)
    {
        $this
            ->setMiscInformation($miscInformation)
            ->setPricedItinerary($pricedItinerary)
            ->setResponseHeader($responseHeader)
            ->setPriceQuotePlus($priceQuotePlus)
            ->setRPH($rPH);
    }
    /**
     * Get MiscInformation value
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation|null
     */
    public function getMiscInformation()
    {
        return $this->MiscInformation;
    }
    /**
     * Set MiscInformation value
     * @param \Sabre\EnhancedAirBook\Structs\MiscInformation $miscInformation
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuote
     */
    public function setMiscInformation(\Sabre\EnhancedAirBook\Structs\MiscInformation $miscInformation = null)
    {
        $this->MiscInformation = $miscInformation;
        return $this;
    }
    /**
     * Get PricedItinerary value
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PricedItinerary[] $pricedItinerary
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuote
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\PricedItinerary $item
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuote
     */
    public function addToPricedItinerary(\Sabre\EnhancedAirBook\Structs\PricedItinerary $item)
    {
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Get ResponseHeader value
     * @return \Sabre\EnhancedAirBook\Structs\ResponseHeader|null
     */
    public function getResponseHeader()
    {
        return $this->ResponseHeader;
    }
    /**
     * Set ResponseHeader value
     * @param \Sabre\EnhancedAirBook\Structs\ResponseHeader $responseHeader
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuote
     */
    public function setResponseHeader(\Sabre\EnhancedAirBook\Structs\ResponseHeader $responseHeader = null)
    {
        $this->ResponseHeader = $responseHeader;
        return $this;
    }
    /**
     * Get PriceQuotePlus value
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuotePlus|null
     */
    public function getPriceQuotePlus()
    {
        return $this->PriceQuotePlus;
    }
    /**
     * Set PriceQuotePlus value
     * @param \Sabre\EnhancedAirBook\Structs\PriceQuotePlus $priceQuotePlus
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuote
     */
    public function setPriceQuotePlus(\Sabre\EnhancedAirBook\Structs\PriceQuotePlus $priceQuotePlus = null)
    {
        $this->PriceQuotePlus = $priceQuotePlus;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuote
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PriceQuote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
