<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceComparison Structs
 * @subpackage Structs
 */
class PriceComparison extends AbstractStructBase
{
    /**
     * The AcceptablePriceIncrease
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AcceptablePriceIncrease
     */
    public $AcceptablePriceIncrease;
    /**
     * The AmountSpecified
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Determines positive only amount | Determines a type for money amount, exchange rate, or percentage etc. Examples: 100.42, 3.9909, 10.1
     * - minExclusive: 0
     * - fractionDigits: 4
     * @var float
     */
    public $AmountSpecified;
    /**
     * The AmountReturned
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AmountReturned;
    /**
     * Constructor method for PriceComparison
     * @uses PriceComparison::setAcceptablePriceIncrease()
     * @uses PriceComparison::setAmountSpecified()
     * @uses PriceComparison::setAmountReturned()
     * @param \Sabre\EnhancedAirBook\Structs\AcceptablePriceIncrease $acceptablePriceIncrease
     * @param float $amountSpecified
     * @param string $amountReturned
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\AcceptablePriceIncrease $acceptablePriceIncrease = null, $amountSpecified = null, $amountReturned = null)
    {
        $this
            ->setAcceptablePriceIncrease($acceptablePriceIncrease)
            ->setAmountSpecified($amountSpecified)
            ->setAmountReturned($amountReturned);
    }
    /**
     * Get AcceptablePriceIncrease value
     * @return \Sabre\EnhancedAirBook\Structs\AcceptablePriceIncrease|null
     */
    public function getAcceptablePriceIncrease()
    {
        return $this->AcceptablePriceIncrease;
    }
    /**
     * Set AcceptablePriceIncrease value
     * @param \Sabre\EnhancedAirBook\Structs\AcceptablePriceIncrease $acceptablePriceIncrease
     * @return \Sabre\EnhancedAirBook\Structs\PriceComparison
     */
    public function setAcceptablePriceIncrease(\Sabre\EnhancedAirBook\Structs\AcceptablePriceIncrease $acceptablePriceIncrease = null)
    {
        $this->AcceptablePriceIncrease = $acceptablePriceIncrease;
        return $this;
    }
    /**
     * Get AmountSpecified value
     * @return float|null
     */
    public function getAmountSpecified()
    {
        return $this->AmountSpecified;
    }
    /**
     * Set AmountSpecified value
     * @param float $amountSpecified
     * @return \Sabre\EnhancedAirBook\Structs\PriceComparison
     */
    public function setAmountSpecified($amountSpecified = null)
    {
        $this->AmountSpecified = $amountSpecified;
        return $this;
    }
    /**
     * Get AmountReturned value
     * @return string|null
     */
    public function getAmountReturned()
    {
        return $this->AmountReturned;
    }
    /**
     * Set AmountReturned value
     * @param string $amountReturned
     * @return \Sabre\EnhancedAirBook\Structs\PriceComparison
     */
    public function setAmountReturned($amountReturned = null)
    {
        $this->AmountReturned = $amountReturned;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PriceComparison
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
