<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscQualifiers Structs
 * @subpackage Structs
 */
class MiscQualifiers extends AbstractStructBase
{
    /**
     * The AirExtras
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public $AirExtras;
    /**
     * The BaggageAllowance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BaggageAllowance[]
     */
    public $BaggageAllowance;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Commission
     */
    public $Commission;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Customer
     */
    public $Customer;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Endorsements
     */
    public $Endorsements;
    /**
     * The HemisphereCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HemisphereCode;
    /**
     * The JourneyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $JourneyCode;
    /**
     * The MultiTicket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\MultiTicket
     */
    public $MultiTicket;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\TourCode
     */
    public $TourCode;
    /**
     * The ValidationMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValidationMethod;
    /**
     * Constructor method for MiscQualifiers
     * @uses MiscQualifiers::setAirExtras()
     * @uses MiscQualifiers::setBaggageAllowance()
     * @uses MiscQualifiers::setCommission()
     * @uses MiscQualifiers::setCustomer()
     * @uses MiscQualifiers::setEndorsements()
     * @uses MiscQualifiers::setHemisphereCode()
     * @uses MiscQualifiers::setJourneyCode()
     * @uses MiscQualifiers::setMultiTicket()
     * @uses MiscQualifiers::setTourCode()
     * @uses MiscQualifiers::setValidationMethod()
     * @param \Sabre\EnhancedAirBook\Structs\AirExtras $airExtras
     * @param \Sabre\EnhancedAirBook\Structs\BaggageAllowance[] $baggageAllowance
     * @param \Sabre\EnhancedAirBook\Structs\Commission $commission
     * @param \Sabre\EnhancedAirBook\Structs\Customer $customer
     * @param \Sabre\EnhancedAirBook\Structs\Endorsements $endorsements
     * @param string $hemisphereCode
     * @param string $journeyCode
     * @param \Sabre\EnhancedAirBook\Structs\MultiTicket $multiTicket
     * @param \Sabre\EnhancedAirBook\Structs\TourCode $tourCode
     * @param string $validationMethod
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\AirExtras $airExtras = null, array $baggageAllowance = array(), \Sabre\EnhancedAirBook\Structs\Commission $commission = null, \Sabre\EnhancedAirBook\Structs\Customer $customer = null, \Sabre\EnhancedAirBook\Structs\Endorsements $endorsements = null, $hemisphereCode = null, $journeyCode = null, \Sabre\EnhancedAirBook\Structs\MultiTicket $multiTicket = null, \Sabre\EnhancedAirBook\Structs\TourCode $tourCode = null, $validationMethod = null)
    {
        $this
            ->setAirExtras($airExtras)
            ->setBaggageAllowance($baggageAllowance)
            ->setCommission($commission)
            ->setCustomer($customer)
            ->setEndorsements($endorsements)
            ->setHemisphereCode($hemisphereCode)
            ->setJourneyCode($journeyCode)
            ->setMultiTicket($multiTicket)
            ->setTourCode($tourCode)
            ->setValidationMethod($validationMethod);
    }
    /**
     * Get AirExtras value
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras|null
     */
    public function getAirExtras()
    {
        return $this->AirExtras;
    }
    /**
     * Set AirExtras value
     * @param \Sabre\EnhancedAirBook\Structs\AirExtras $airExtras
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setAirExtras(\Sabre\EnhancedAirBook\Structs\AirExtras $airExtras = null)
    {
        $this->AirExtras = $airExtras;
        return $this;
    }
    /**
     * Get BaggageAllowance value
     * @return \Sabre\EnhancedAirBook\Structs\BaggageAllowance[]|null
     */
    public function getBaggageAllowance()
    {
        return $this->BaggageAllowance;
    }
    /**
     * Set BaggageAllowance value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\BaggageAllowance[] $baggageAllowance
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setBaggageAllowance(array $baggageAllowance = array())
    {
        $this->BaggageAllowance = $baggageAllowance;
        return $this;
    }
    /**
     * Add item to BaggageAllowance value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\BaggageAllowance $item
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function addToBaggageAllowance(\Sabre\EnhancedAirBook\Structs\BaggageAllowance $item)
    {
        $this->BaggageAllowance[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \Sabre\EnhancedAirBook\Structs\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \Sabre\EnhancedAirBook\Structs\Commission $commission
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setCommission(\Sabre\EnhancedAirBook\Structs\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Sabre\EnhancedAirBook\Structs\Customer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Sabre\EnhancedAirBook\Structs\Customer $customer
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setCustomer(\Sabre\EnhancedAirBook\Structs\Customer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \Sabre\EnhancedAirBook\Structs\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \Sabre\EnhancedAirBook\Structs\Endorsements $endorsements
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setEndorsements(\Sabre\EnhancedAirBook\Structs\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get HemisphereCode value
     * @return string|null
     */
    public function getHemisphereCode()
    {
        return $this->HemisphereCode;
    }
    /**
     * Set HemisphereCode value
     * @param string $hemisphereCode
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setHemisphereCode($hemisphereCode = null)
    {
        $this->HemisphereCode = $hemisphereCode;
        return $this;
    }
    /**
     * Get JourneyCode value
     * @return string|null
     */
    public function getJourneyCode()
    {
        return $this->JourneyCode;
    }
    /**
     * Set JourneyCode value
     * @param string $journeyCode
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setJourneyCode($journeyCode = null)
    {
        $this->JourneyCode = $journeyCode;
        return $this;
    }
    /**
     * Get MultiTicket value
     * @return \Sabre\EnhancedAirBook\Structs\MultiTicket|null
     */
    public function getMultiTicket()
    {
        return $this->MultiTicket;
    }
    /**
     * Set MultiTicket value
     * @param \Sabre\EnhancedAirBook\Structs\MultiTicket $multiTicket
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setMultiTicket(\Sabre\EnhancedAirBook\Structs\MultiTicket $multiTicket = null)
    {
        $this->MultiTicket = $multiTicket;
        return $this;
    }
    /**
     * Get TourCode value
     * @return \Sabre\EnhancedAirBook\Structs\TourCode|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param \Sabre\EnhancedAirBook\Structs\TourCode $tourCode
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setTourCode(\Sabre\EnhancedAirBook\Structs\TourCode $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get ValidationMethod value
     * @return string|null
     */
    public function getValidationMethod()
    {
        return $this->ValidationMethod;
    }
    /**
     * Set ValidationMethod value
     * @param string $validationMethod
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public function setValidationMethod($validationMethod = null)
    {
        $this->ValidationMethod = $validationMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\MiscQualifiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
