<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item Structs
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The TicketingCarrier
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TicketingCarrier;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * The SalePseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SalePseudoCityCode;
    /**
     * The AirFareInfo
     * @var \Sabre\EnhancedAirBook\Structs\AirFareInfo
     */
    public $AirFareInfo;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var int
     */
    public $RPH;
    /**
     * The AirTaxi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AirTaxi
     */
    public $AirTaxi;
    /**
     * The Arunk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Arunk
     */
    public $Arunk;
    /**
     * The Cruise
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Cruise
     */
    public $Cruise;
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Hotel
     */
    public $Hotel;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Insurance
     */
    public $Insurance;
    /**
     * The MiscSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\MiscSegment
     */
    public $MiscSegment;
    /**
     * The Rail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Rail
     */
    public $Rail;
    /**
     * The Seats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Seats
     */
    public $Seats;
    /**
     * The Surface
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Surface
     */
    public $Surface;
    /**
     * The Tour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Tour
     */
    public $Tour;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Vehicle
     */
    public $Vehicle;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ProductType
     */
    public $Product;
    /**
     * The Ancillaries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Ancillaries
     */
    public $Ancillaries;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Item
     * @uses Item::setTicketingCarrier()
     * @uses Item::setValidatingCarrier()
     * @uses Item::setSalePseudoCityCode()
     * @uses Item::setAirFareInfo()
     * @uses Item::setFlightSegment()
     * @uses Item::setRPH()
     * @uses Item::setAirTaxi()
     * @uses Item::setArunk()
     * @uses Item::setCruise()
     * @uses Item::setHotel()
     * @uses Item::setInsurance()
     * @uses Item::setMiscSegment()
     * @uses Item::setRail()
     * @uses Item::setSeats()
     * @uses Item::setSurface()
     * @uses Item::setTour()
     * @uses Item::setVehicle()
     * @uses Item::setProduct()
     * @uses Item::setAncillaries()
     * @uses Item::setId()
     * @param string $ticketingCarrier
     * @param string $validatingCarrier
     * @param string $salePseudoCityCode
     * @param \Sabre\EnhancedAirBook\Structs\AirFareInfo $airFareInfo
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment[] $flightSegment
     * @param int $rPH
     * @param \Sabre\EnhancedAirBook\Structs\AirTaxi $airTaxi
     * @param \Sabre\EnhancedAirBook\Structs\Arunk $arunk
     * @param \Sabre\EnhancedAirBook\Structs\Cruise $cruise
     * @param \Sabre\EnhancedAirBook\Structs\Hotel $hotel
     * @param \Sabre\EnhancedAirBook\Structs\Insurance $insurance
     * @param \Sabre\EnhancedAirBook\Structs\MiscSegment $miscSegment
     * @param \Sabre\EnhancedAirBook\Structs\Rail $rail
     * @param \Sabre\EnhancedAirBook\Structs\Seats $seats
     * @param \Sabre\EnhancedAirBook\Structs\Surface $surface
     * @param \Sabre\EnhancedAirBook\Structs\Tour $tour
     * @param \Sabre\EnhancedAirBook\Structs\Vehicle $vehicle
     * @param \Sabre\EnhancedAirBook\Structs\ProductType $product
     * @param \Sabre\EnhancedAirBook\Structs\Ancillaries $ancillaries
     * @param string $id
     */
    public function __construct($ticketingCarrier = null, $validatingCarrier = null, $salePseudoCityCode = null, \Sabre\EnhancedAirBook\Structs\AirFareInfo $airFareInfo = null, array $flightSegment = array(), $rPH = null, \Sabre\EnhancedAirBook\Structs\AirTaxi $airTaxi = null, \Sabre\EnhancedAirBook\Structs\Arunk $arunk = null, \Sabre\EnhancedAirBook\Structs\Cruise $cruise = null, \Sabre\EnhancedAirBook\Structs\Hotel $hotel = null, \Sabre\EnhancedAirBook\Structs\Insurance $insurance = null, \Sabre\EnhancedAirBook\Structs\MiscSegment $miscSegment = null, \Sabre\EnhancedAirBook\Structs\Rail $rail = null, \Sabre\EnhancedAirBook\Structs\Seats $seats = null, \Sabre\EnhancedAirBook\Structs\Surface $surface = null, \Sabre\EnhancedAirBook\Structs\Tour $tour = null, \Sabre\EnhancedAirBook\Structs\Vehicle $vehicle = null, \Sabre\EnhancedAirBook\Structs\ProductType $product = null, \Sabre\EnhancedAirBook\Structs\Ancillaries $ancillaries = null, $id = null)
    {
        $this
            ->setTicketingCarrier($ticketingCarrier)
            ->setValidatingCarrier($validatingCarrier)
            ->setSalePseudoCityCode($salePseudoCityCode)
            ->setAirFareInfo($airFareInfo)
            ->setFlightSegment($flightSegment)
            ->setRPH($rPH)
            ->setAirTaxi($airTaxi)
            ->setArunk($arunk)
            ->setCruise($cruise)
            ->setHotel($hotel)
            ->setInsurance($insurance)
            ->setMiscSegment($miscSegment)
            ->setRail($rail)
            ->setSeats($seats)
            ->setSurface($surface)
            ->setTour($tour)
            ->setVehicle($vehicle)
            ->setProduct($product)
            ->setAncillaries($ancillaries)
            ->setId($id);
    }
    /**
     * Get TicketingCarrier value
     * @return string
     */
    public function getTicketingCarrier()
    {
        return $this->TicketingCarrier;
    }
    /**
     * Set TicketingCarrier value
     * @param string $ticketingCarrier
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setTicketingCarrier($ticketingCarrier = null)
    {
        $this->TicketingCarrier = $ticketingCarrier;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Get SalePseudoCityCode value
     * @return string
     */
    public function getSalePseudoCityCode()
    {
        return $this->SalePseudoCityCode;
    }
    /**
     * Set SalePseudoCityCode value
     * @param string $salePseudoCityCode
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setSalePseudoCityCode($salePseudoCityCode = null)
    {
        $this->SalePseudoCityCode = $salePseudoCityCode;
        return $this;
    }
    /**
     * Get AirFareInfo value
     * @return \Sabre\EnhancedAirBook\Structs\AirFareInfo|null
     */
    public function getAirFareInfo()
    {
        return $this->AirFareInfo;
    }
    /**
     * Set AirFareInfo value
     * @param \Sabre\EnhancedAirBook\Structs\AirFareInfo $airFareInfo
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setAirFareInfo(\Sabre\EnhancedAirBook\Structs\AirFareInfo $airFareInfo = null)
    {
        $this->AirFareInfo = $airFareInfo;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment $item
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function addToFlightSegment(\Sabre\EnhancedAirBook\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AirTaxi value
     * @return \Sabre\EnhancedAirBook\Structs\AirTaxi|null
     */
    public function getAirTaxi()
    {
        return $this->AirTaxi;
    }
    /**
     * Set AirTaxi value
     * @param \Sabre\EnhancedAirBook\Structs\AirTaxi $airTaxi
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setAirTaxi(\Sabre\EnhancedAirBook\Structs\AirTaxi $airTaxi = null)
    {
        $this->AirTaxi = $airTaxi;
        return $this;
    }
    /**
     * Get Arunk value
     * @return \Sabre\EnhancedAirBook\Structs\Arunk|null
     */
    public function getArunk()
    {
        return $this->Arunk;
    }
    /**
     * Set Arunk value
     * @param \Sabre\EnhancedAirBook\Structs\Arunk $arunk
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setArunk(\Sabre\EnhancedAirBook\Structs\Arunk $arunk = null)
    {
        $this->Arunk = $arunk;
        return $this;
    }
    /**
     * Get Cruise value
     * @return \Sabre\EnhancedAirBook\Structs\Cruise|null
     */
    public function getCruise()
    {
        return $this->Cruise;
    }
    /**
     * Set Cruise value
     * @param \Sabre\EnhancedAirBook\Structs\Cruise $cruise
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setCruise(\Sabre\EnhancedAirBook\Structs\Cruise $cruise = null)
    {
        $this->Cruise = $cruise;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \Sabre\EnhancedAirBook\Structs\Hotel|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @param \Sabre\EnhancedAirBook\Structs\Hotel $hotel
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setHotel(\Sabre\EnhancedAirBook\Structs\Hotel $hotel = null)
    {
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \Sabre\EnhancedAirBook\Structs\Insurance|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param \Sabre\EnhancedAirBook\Structs\Insurance $insurance
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setInsurance(\Sabre\EnhancedAirBook\Structs\Insurance $insurance = null)
    {
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get MiscSegment value
     * @return \Sabre\EnhancedAirBook\Structs\MiscSegment|null
     */
    public function getMiscSegment()
    {
        return $this->MiscSegment;
    }
    /**
     * Set MiscSegment value
     * @param \Sabre\EnhancedAirBook\Structs\MiscSegment $miscSegment
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setMiscSegment(\Sabre\EnhancedAirBook\Structs\MiscSegment $miscSegment = null)
    {
        $this->MiscSegment = $miscSegment;
        return $this;
    }
    /**
     * Get Rail value
     * @return \Sabre\EnhancedAirBook\Structs\Rail|null
     */
    public function getRail()
    {
        return $this->Rail;
    }
    /**
     * Set Rail value
     * @param \Sabre\EnhancedAirBook\Structs\Rail $rail
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setRail(\Sabre\EnhancedAirBook\Structs\Rail $rail = null)
    {
        $this->Rail = $rail;
        return $this;
    }
    /**
     * Get Seats value
     * @return \Sabre\EnhancedAirBook\Structs\Seats|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \Sabre\EnhancedAirBook\Structs\Seats $seats
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setSeats(\Sabre\EnhancedAirBook\Structs\Seats $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
    /**
     * Get Surface value
     * @return \Sabre\EnhancedAirBook\Structs\Surface|null
     */
    public function getSurface()
    {
        return $this->Surface;
    }
    /**
     * Set Surface value
     * @param \Sabre\EnhancedAirBook\Structs\Surface $surface
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setSurface(\Sabre\EnhancedAirBook\Structs\Surface $surface = null)
    {
        $this->Surface = $surface;
        return $this;
    }
    /**
     * Get Tour value
     * @return \Sabre\EnhancedAirBook\Structs\Tour|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param \Sabre\EnhancedAirBook\Structs\Tour $tour
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setTour(\Sabre\EnhancedAirBook\Structs\Tour $tour = null)
    {
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \Sabre\EnhancedAirBook\Structs\Vehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \Sabre\EnhancedAirBook\Structs\Vehicle $vehicle
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setVehicle(\Sabre\EnhancedAirBook\Structs\Vehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Product value
     * @return \Sabre\EnhancedAirBook\Structs\ProductType|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \Sabre\EnhancedAirBook\Structs\ProductType $product
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setProduct(\Sabre\EnhancedAirBook\Structs\ProductType $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Ancillaries value
     * @return \Sabre\EnhancedAirBook\Structs\Ancillaries|null
     */
    public function getAncillaries()
    {
        return $this->Ancillaries;
    }
    /**
     * Set Ancillaries value
     * @param \Sabre\EnhancedAirBook\Structs\Ancillaries $ancillaries
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setAncillaries(\Sabre\EnhancedAirBook\Structs\Ancillaries $ancillaries = null)
    {
        $this->Ancillaries = $ancillaries;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
