<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoverningCarrierOverride Structs
 * @subpackage Structs
 */
class GoverningCarrierOverride extends AbstractStructBase
{
    /**
     * The Airline
     * @var \Sabre\EnhancedAirBook\Structs\Airline
     */
    public $Airline;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for GoverningCarrierOverride
     * @uses GoverningCarrierOverride::setAirline()
     * @uses GoverningCarrierOverride::setRPH()
     * @param \Sabre\EnhancedAirBook\Structs\Airline $airline
     * @param string $rPH
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Airline $airline = null, $rPH = null)
    {
        $this
            ->setAirline($airline)
            ->setRPH($rPH);
    }
    /**
     * Get Airline value
     * @return \Sabre\EnhancedAirBook\Structs\Airline|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \Sabre\EnhancedAirBook\Structs\Airline $airline
     * @return \Sabre\EnhancedAirBook\Structs\GoverningCarrierOverride
     */
    public function setAirline(\Sabre\EnhancedAirBook\Structs\Airline $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\GoverningCarrierOverride
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\GoverningCarrierOverride
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
