<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommandPricing Structs
 * @subpackage Structs
 */
class CommandPricing extends AbstractStructBase
{
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Discount
     */
    public $Discount;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareBasis
     */
    public $FareBasis;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for CommandPricing
     * @uses CommandPricing::setDiscount()
     * @uses CommandPricing::setFareBasis()
     * @uses CommandPricing::setRPH()
     * @param \Sabre\EnhancedAirBook\Structs\Discount $discount
     * @param \Sabre\EnhancedAirBook\Structs\FareBasis $fareBasis
     * @param string $rPH
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Discount $discount = null, \Sabre\EnhancedAirBook\Structs\FareBasis $fareBasis = null, $rPH = null)
    {
        $this
            ->setDiscount($discount)
            ->setFareBasis($fareBasis)
            ->setRPH($rPH);
    }
    /**
     * Get Discount value
     * @return \Sabre\EnhancedAirBook\Structs\Discount|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \Sabre\EnhancedAirBook\Structs\Discount $discount
     * @return \Sabre\EnhancedAirBook\Structs\CommandPricing
     */
    public function setDiscount(\Sabre\EnhancedAirBook\Structs\Discount $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\EnhancedAirBook\Structs\FareBasis|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param \Sabre\EnhancedAirBook\Structs\FareBasis $fareBasis
     * @return \Sabre\EnhancedAirBook\Structs\CommandPricing
     */
    public function setFareBasis(\Sabre\EnhancedAirBook\Structs\FareBasis $fareBasis = null)
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\CommandPricing
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\CommandPricing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
